/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.copy.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.copy.command.CopyDataToClipboardCommand;
import org.eclipse.nebula.widgets.nattable.copy.serializing.CopyDataToClipboardSerializer;
import org.eclipse.nebula.widgets.nattable.copy.serializing.CopyFormattedTextToClipboardSerializer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class CopyDataCommandHandler
extends AbstractLayerCommandHandler<CopyDataToClipboardCommand> {
    private final SelectionLayer selectionLayer;
    private final ILayer columnHeaderDataLayer;
    private final ILayer rowHeaderDataLayer;
    private IUniqueIndexLayer copyLayer;
    private boolean copyFormattedText;

    public CopyDataCommandHandler(SelectionLayer selectionLayer) {
        this(selectionLayer, null, null);
    }

    public CopyDataCommandHandler(SelectionLayer selectionLayer, ILayer columnHeaderDataLayer, ILayer rowHeaderDataLayer) {
        assert (selectionLayer != null) : "The SelectionLayer can not be null on creating a CopyDataCommandHandler";
        this.selectionLayer = selectionLayer;
        this.columnHeaderDataLayer = columnHeaderDataLayer;
        this.rowHeaderDataLayer = rowHeaderDataLayer;
    }

    public void setCopyLayer(IUniqueIndexLayer copyLayer) {
        this.copyLayer = copyLayer;
    }

    public void setCopyFormattedText(boolean copyFormattedText) {
        this.copyFormattedText = copyFormattedText;
    }

    @Override
    public boolean doCommand(CopyDataToClipboardCommand command) {
        CopyDataToClipboardSerializer serializer = this.copyFormattedText ? new CopyFormattedTextToClipboardSerializer(this.assembleCopiedDataStructure(), command) : new CopyDataToClipboardSerializer(this.assembleCopiedDataStructure(), command);
        serializer.serialize();
        return true;
    }

    @Override
    public Class<CopyDataToClipboardCommand> getCommandClass() {
        return CopyDataToClipboardCommand.class;
    }

    protected ILayerCell[][] assembleCopiedDataStructure() {
        Set<Range> selectedRows = this.selectionLayer.getSelectedRowPositions();
        ILayerCell[][] copiedCells = this.assembleColumnHeaders();
        ArrayList<Integer> selectedRowPositions = new ArrayList<Integer>();
        for (Range range : selectedRows) {
            int rowPosition = range.start;
            while (rowPosition < range.end) {
                selectedRowPositions.add(rowPosition);
                ++rowPosition;
            }
        }
        Collections.sort(selectedRowPositions);
        int rowOffset = this.columnHeaderDataLayer != null ? this.columnHeaderDataLayer.getRowCount() : 0;
        int i = 0;
        while (i < selectedRowPositions.size()) {
            Integer rowPos = (Integer)selectedRowPositions.get(i);
            copiedCells[i + rowOffset] = this.assembleBody(rowPos);
            ++i;
        }
        return copiedCells;
    }

    protected ILayerCell[][] assembleColumnHeaders() {
        int rowOffset = this.columnHeaderDataLayer != null ? this.columnHeaderDataLayer.getRowCount() : 0;
        int columnOffset = this.rowHeaderDataLayer != null ? this.rowHeaderDataLayer.getColumnCount() : 0;
        ILayerCell[][] copiedCells = new ILayerCell[this.selectionLayer.getSelectedRowCount() + rowOffset][1];
        if (this.columnHeaderDataLayer != null) {
            int[] selectedColumnPositions = this.selectionLayer.getSelectedColumnPositions();
            int i = 0;
            while (i < rowOffset) {
                ILayerCell[] cells = new ILayerCell[selectedColumnPositions.length + columnOffset];
                int columnPosition = 0;
                while (columnPosition < selectedColumnPositions.length) {
                    cells[columnPosition + columnOffset] = this.columnHeaderDataLayer.getCellByPosition(selectedColumnPositions[columnPosition], i);
                    ++columnPosition;
                }
                copiedCells[i] = cells;
                ++i;
            }
        }
        return copiedCells;
    }

    protected ILayerCell[] assembleBody(int currentRowPosition) {
        int[] selectedColumns = this.selectionLayer.getSelectedColumnPositions();
        int columnOffset = this.rowHeaderDataLayer != null ? this.rowHeaderDataLayer.getColumnCount() : 0;
        ILayerCell[] bodyCells = new ILayerCell[selectedColumns.length + columnOffset];
        if (this.rowHeaderDataLayer != null) {
            int i = 0;
            while (i < this.rowHeaderDataLayer.getColumnCount()) {
                bodyCells[i] = this.rowHeaderDataLayer.getCellByPosition(i, currentRowPosition);
                ++i;
            }
        }
        int columnPosition = 0;
        while (columnPosition < selectedColumns.length) {
            int selectedColumnPosition = selectedColumns[columnPosition];
            if (this.selectionLayer.isCellPositionSelected(selectedColumnPosition, currentRowPosition)) {
                if (this.copyLayer == null) {
                    bodyCells[columnPosition + columnOffset] = this.selectionLayer.getCellByPosition(selectedColumnPosition, currentRowPosition);
                } else {
                    int copyColPos = LayerUtil.convertColumnPosition(this.selectionLayer, selectedColumnPosition, this.copyLayer);
                    int copyRowPos = LayerUtil.convertRowPosition(this.selectionLayer, currentRowPosition, this.copyLayer);
                    bodyCells[columnPosition + columnOffset] = this.copyLayer.getCellByPosition(copyColPos, copyRowPos);
                }
            }
            ++columnPosition;
        }
        return bodyCells;
    }
}

