/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.ui.views;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.swt.ui.components.baseline.BaselineAndChromatogramUI;
import org.eclipse.chemclipse.swt.ui.support.AxisTitlesIntensityScale;
import org.eclipse.chemclipse.swt.ui.support.IAxisTitles;
import org.eclipse.chemclipse.ux.extension.ui.views.AbstractChromatogramSelectionView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class BaselineAndChromatogramView
extends AbstractChromatogramSelectionView {
    @Inject
    private Composite parent;
    private BaselineAndChromatogramUI baselineAndChromatogramUI;

    @Inject
    public BaselineAndChromatogramView(EPartService partService, MPart part, IEventBroker eventBroker) {
        super(part, partService, eventBroker);
    }

    @PostConstruct
    private void createControl() {
        this.parent.setLayout((Layout)new FillLayout());
        this.baselineAndChromatogramUI = new BaselineAndChromatogramUI(this.parent, 0, (IAxisTitles)new AxisTitlesIntensityScale());
    }

    @PreDestroy
    private void preDestroy() {
        this.unsubscribe();
    }

    @Focus
    public void setFocus() {
        this.baselineAndChromatogramUI.setFocus();
        this.update(this.getChromatogramSelection(), false);
    }

    @Override
    public void update(IChromatogramSelection chromatogramSelection, boolean forceReload) {
        if (this.doUpdate(chromatogramSelection)) {
            this.baselineAndChromatogramUI.updateSelection(chromatogramSelection, forceReload);
        }
    }
}

