/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.editors;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.converter.exceptions.NoChromatogramConverterAvailableException;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.msd.converter.exceptions.NoMassSpectrumConverterAvailableException;
import org.eclipse.chemclipse.msd.converter.massspectrum.MassSpectrumConverter;
import org.eclipse.chemclipse.msd.converter.processing.massspectrum.IMassSpectrumExportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IRegularLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.notifier.MassSpectrumSelectionUpdateNotifier;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.MassValueDisplayPrecision;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.SimpleContinuousMassSpectrumUI;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.SimpleMassSpectrumUI;
import org.eclipse.chemclipse.msd.swt.ui.support.MassSpectraFileSupport;
import org.eclipse.chemclipse.processing.core.exceptions.TypeCastException;
import org.eclipse.chemclipse.ux.extension.msd.ui.internal.support.MassSpectrumImportRunnable;
import org.eclipse.chemclipse.ux.extension.msd.ui.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.ux.extension.ui.editors.IChemClipseEditor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class MassSpectrumEditor
implements IChemClipseEditor {
    public static final String ID = "org.eclipse.chemclipse.ux.extension.msd.ui.part.massSpectrumEditor";
    public static final String CONTRIBUTION_URI = "bundleclass://org.eclipse.chemclipse.ux.extension.msd.ui/org.eclipse.chemclipse.ux.extension.msd.ui.editors.MassSpectrumEditor";
    public static final String ICON_URI = "platform:/plugin/org.eclipse.chemclipse.rcp.ui.icons/icons/16x16/massSpectrum.gif";
    public static final String TOOLTIP = "Mass Spectrum - Detector Type: MSD";
    private static final Logger logger = Logger.getLogger(MassSpectrumEditor.class);
    @Inject
    private MPart part;
    @Inject
    private MDirtyable dirtyable;
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;
    @Inject
    private IEventBroker eventBroker;
    private File massSpectrumFile;
    private IMassSpectra massSpectra;
    private IScanMSD massSpectrum;
    private TabFolder tabFolder;

    @PostConstruct
    private void createControl(Composite parent) {
        this.loadMassSpectra();
        this.createPages(parent);
    }

    @Focus
    public void setFocus() {
        this.eventBroker.post("scan/msd/update/selection", (Object)this.massSpectra);
        if (this.massSpectrum != null) {
            MassSpectrumSelectionUpdateNotifier.fireUpdateChange((IScanMSD)this.massSpectrum, (boolean)true);
        }
    }

    @PreDestroy
    private void preDestroy() {
        this.eventBroker.post("scan/xxd/unload/selection", null);
        if (this.modelService != null) {
            MPartStack partStack = (MPartStack)this.modelService.find("org.eclipse.e4.primaryDataStack", (MUIElement)this.application);
            this.part.setToBeRendered(false);
            this.part.setVisible(false);
            partStack.getChildren().remove(this.part);
        }
        System.gc();
    }

    @Persist
    public boolean save() {
        final Shell shell = Display.getCurrent().getActiveShell();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask("Save Mass Spectra", -1);
                    try {
                        MassSpectrumEditor.this.saveMassSpectra(monitor, shell);
                    }
                    catch (NoMassSpectrumConverterAvailableException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            dialog.run(true, false, runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
            return this.saveAs();
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
            return false;
        }
        return true;
    }

    private void saveMassSpectra(IProgressMonitor monitor, Shell shell) throws NoMassSpectrumConverterAvailableException {
        if (this.massSpectrumFile != null && this.massSpectra != null && shell != null) {
            String converterId = this.massSpectra.getConverterId();
            if (converterId != null && !converterId.equals("")) {
                monitor.subTask("Save Mass Spectrum");
                IMassSpectrumExportConverterProcessingInfo processingInfo = MassSpectrumConverter.convert((File)this.massSpectrumFile, (IMassSpectra)this.massSpectra, (boolean)false, (String)converterId, (IProgressMonitor)monitor);
                try {
                    processingInfo.getFile();
                    this.dirtyable.setDirty(false);
                }
                catch (TypeCastException e) {
                    logger.warn((Object)e);
                }
            } else {
                throw new NoMassSpectrumConverterAvailableException();
            }
        }
    }

    public boolean saveAs() {
        boolean saveSuccessful = false;
        if (this.massSpectra != null) {
            try {
                saveSuccessful = MassSpectraFileSupport.saveMassSpectra((IMassSpectra)this.massSpectra);
                this.dirtyable.setDirty(!saveSuccessful);
            }
            catch (NoConverterAvailableException e) {
                logger.warn((Object)e);
            }
        }
        return saveSuccessful;
    }

    private void loadMassSpectra() {
        try {
            Object object = this.part.getObject();
            if (object instanceof String) {
                File file = new File((String)object);
                this.importMassSpectrum(file);
            }
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
    }

    private void importMassSpectrum(File file) throws FileNotFoundException, NoChromatogramConverterAvailableException, FileIsNotReadableException, FileIsEmptyException, ChromatogramIsNullException {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        MassSpectrumImportRunnable runnable = new MassSpectrumImportRunnable(file, this.massSpectra);
        try {
            dialog.run(true, false, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            logger.warn((Object)e);
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
        }
        this.dirtyable.setDirty(true);
        this.massSpectra = runnable.getMassSpectra();
        this.massSpectrumFile = file;
    }

    private void createPages(Composite parent) {
        if (this.massSpectra != null && this.massSpectra.getMassSpectrum(1) != null) {
            this.tabFolder = new TabFolder(parent, 1024);
            this.createMassSpectrumPage();
        } else {
            this.createErrorMessagePage(parent);
        }
    }

    private void createMassSpectrumPage() {
        ILibraryInformation libraryInformation;
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("Mass Spectrum");
        String name = "".equals(this.massSpectra.getName()) ? "NoName" : this.massSpectra.getName();
        this.massSpectrum = this.massSpectra.getMassSpectrum(1);
        if (this.massSpectrum instanceof IVendorMassSpectrum) {
            name = ((IVendorMassSpectrum)this.massSpectrum).getName();
        } else if (this.massSpectrum instanceof IRegularLibraryMassSpectrum && (libraryInformation = ((IRegularLibraryMassSpectrum)this.massSpectrum).getLibraryInformation()) != null) {
            name = libraryInformation.getName();
        }
        this.part.setLabel(name);
        boolean isProfile = PreferenceSupplier.useProfileMassSpectrumView();
        Object massSpectrumUI = isProfile ? new SimpleContinuousMassSpectrumUI((Composite)this.tabFolder, 0, MassValueDisplayPrecision.EXACT) : new SimpleMassSpectrumUI((Composite)this.tabFolder, 0, MassValueDisplayPrecision.EXACT);
        massSpectrumUI.update(this.massSpectrum, true);
        tabItem.setControl((Control)massSpectrumUI);
    }

    private void createErrorMessagePage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        Label label = new Label(composite, 0);
        label.setText("The mass spectrum couldn't be loaded.");
    }
}

