/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.webapp.HelpWebappPlugin;
import org.eclipse.help.internal.webapp.data.RequestData;
import org.eclipse.help.internal.webapp.data.ServletResources;
import org.eclipse.help.internal.webapp.data.ToolbarButton;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.webapp.AbstractButton;

public class ToolbarData
extends RequestData {
    private static final String BUTTON_EXTENSION_POINT = "org.eclipse.help.webapp.toolbarButton";
    private ToolbarButton[] buttons;
    private String[] scriptFiles;
    private static Pattern jsNamePattern = Pattern.compile("^[a-zA-Z_$][a-zA-Z1-9_]*");

    public ToolbarData(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context, request, response);
        this.loadButtons();
    }

    public boolean hasMenu() {
        ToolbarButton[] toolbarButtonArray = this.buttons;
        int n = this.buttons.length;
        int n2 = 0;
        while (n2 < n) {
            ToolbarButton button = toolbarButtonArray[n2];
            if ("menu".equals(button.getAction())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void loadButtons() {
        String[] names = this.request.getParameterValues("name");
        String[] tooltips = this.request.getParameterValues("tooltip");
        String[] images = this.request.getParameterValues("image");
        String[] actions = this.request.getParameterValues("action");
        String[] params = this.request.getParameterValues("param");
        String[] states = this.request.getParameterValues("state");
        if (names == null || tooltips == null || images == null || actions == null || params == null || states == null || names.length != tooltips.length || names.length != images.length || names.length != actions.length || names.length != params.length || names.length != states.length) {
            this.buttons = new ToolbarButton[0];
            this.scriptFiles = new String[0];
            return;
        }
        ArrayList<ToolbarButton> buttonList = new ArrayList<ToolbarButton>();
        int i = 0;
        while (i < names.length) {
            if ("".equals(names[i])) {
                buttonList.add(new ToolbarButton());
            } else {
                Matcher matcher = jsNamePattern.matcher(names[i]);
                if (matcher.matches()) {
                    buttonList.add(new ToolbarButton(names[i], ServletResources.getString(tooltips[i], this.request), String.valueOf(this.preferences.getImagesDirectory()) + "/e_" + images[i], actions[i], params[i], states[i]));
                }
            }
            ++i;
        }
        this.addExtensionButtons(buttonList);
        if (this.isIE() || this.isMozilla() && "1.2.1".compareTo(this.getMozillaVersion()) <= 0 || this.isSafari() && "120".compareTo(this.getSafariVersion()) <= 0) {
            buttonList.add(new ToolbarButton("maximize_restore", this.getMaximizeTooltip(), String.valueOf(this.preferences.getImagesDirectory()) + "/" + "maximize.gif", "restore_maximize", null, "off"));
        }
        this.buttons = buttonList.toArray(new ToolbarButton[buttonList.size()]);
    }

    private void addExtensionButtons(List<ToolbarButton> buttonList) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(BUTTON_EXTENSION_POINT);
        ArrayList<AbstractButton> extensionButtons = new ArrayList<AbstractButton>();
        ArrayList<String> scripts = new ArrayList<String>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            Object obj = null;
            try {
                obj = element.createExecutableExtension("class");
            }
            catch (CoreException e) {
                HelpWebappPlugin.logError("Create extension failed:[org.eclipse.help.webapp.toolbarButton].", e);
            }
            if (obj instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)obj;
                String toolbarName = this.request.getParameter("view");
                if (toolbarName == null) {
                    toolbarName = this.request.getParameter("toolbar");
                }
                if (button.isAddedToToolbar(toolbarName)) {
                    extensionButtons.add(button);
                }
            }
            ++n2;
        }
        Collections.sort(extensionButtons);
        for (AbstractButton button : extensionButtons) {
            String scriptFile = button.getJavaScriptURL();
            if (scriptFile != null) {
                scripts.add(UrlUtil.getRelativePath(this.request, scriptFile));
            }
            ToolbarButton toolButton = new ToolbarButton(button.getId(), button.getTooltip(UrlUtil.getLocaleObj(this.request, this.response)), String.valueOf(this.request.getContextPath()) + button.getImageURL(), button.getAction(), "", button.getState());
            buttonList.add(toolButton);
        }
        this.scriptFiles = scripts.toArray(new String[scripts.size()]);
    }

    public ToolbarButton[] getButtons() {
        return this.buttons;
    }

    public String getName() {
        if (this.request.getParameter("view") == null) {
            return "";
        }
        return this.request.getParameter("view");
    }

    public String getTitle() {
        if (this.request.getParameter("view") == null) {
            return "";
        }
        return ServletResources.getString(this.request.getParameter("view"), this.request);
    }

    public String getScript() {
        return this.request.getParameter("script");
    }

    public String getMaximizeImage() {
        return String.valueOf(this.preferences.getImagesDirectory()) + "/e_maximize.gif";
    }

    public String getRestoreImage() {
        return String.valueOf(this.preferences.getImagesDirectory()) + "/e_restore.gif";
    }

    public String getMaximizeTooltip() {
        return ServletResources.getString("maximize", this.request);
    }

    public String getRestoreTooltip() {
        return ServletResources.getString("restore", this.request);
    }

    public String[] getScriptFiles() {
        return this.scriptFiles;
    }
}

