/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.swt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.IQuantDatabase;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.provider.QuantitationPeaksContentProvider;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.provider.QuantitationPeaksLabelProvider;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.provider.QuantitationPeaksTableComparator;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.swt.AbstractTableViewerUI;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.swt.IQuantitationCompoundUpdater;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationCompoundMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationPeakMSD;
import org.eclipse.chemclipse.msd.model.implementation.QuantitationPeakMSD;
import org.eclipse.chemclipse.msd.model.notifier.PeakSelectionUpdateNotifier;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class QuantitationPeaksListUI
extends AbstractTableViewerUI
implements IQuantitationCompoundUpdater {
    private static final String MESSAGE_BOX_TEXT = "Quantitation Peaks";
    private IQuantitationCompoundMSD quantitationCompoundDocument;
    private IEventBroker eventBroker;
    private IQuantDatabase database;
    private Map<String, Object> map;

    public QuantitationPeaksListUI(Composite parent, int style, IEventBroker eventBroker) {
        parent.setLayout((Layout)new FillLayout());
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.addList(composite);
        this.addButtons(composite);
        this.eventBroker = eventBroker;
        this.map = new HashMap<String, Object>();
    }

    @Override
    public void update(IQuantitationCompoundMSD quantitationCompoundDocument, IQuantDatabase database) {
        this.database = database;
        this.quantitationCompoundDocument = quantitationCompoundDocument;
        if (quantitationCompoundDocument == null || database == null) {
            this.getTableViewer().setInput(null);
        } else {
            this.setTableViewerInput();
        }
    }

    private void addList(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridDataTable = new GridData(1808);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)gridDataTable);
        String[] titles = new String[]{"Concentration", "Concentration Unit"};
        int[] bounds = new int[]{100, 100};
        QuantitationPeaksContentProvider contentProvider = new QuantitationPeaksContentProvider();
        QuantitationPeaksLabelProvider labelProvider = new QuantitationPeaksLabelProvider();
        QuantitationPeaksTableComparator viewerTableComparator = new QuantitationPeaksTableComparator();
        this.createTableViewer(composite, gridDataTable, contentProvider, (LabelProvider)labelProvider, viewerTableComparator, titles, bounds);
        this.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IQuantitationPeakMSD quantitationPeakDocument = QuantitationPeaksListUI.this.getSelectedQuantitationPeak();
                if (quantitationPeakDocument != null) {
                    IPeakMSD peakMSD = quantitationPeakDocument.getReferencePeakMSD();
                    PeakSelectionUpdateNotifier.fireUpdateChange((IPeakMSD)peakMSD, (boolean)true);
                }
            }
        });
        this.setTableViewerInput();
    }

    private void setTableViewerInput() {
        if (this.database != null && this.quantitationCompoundDocument != null) {
            List quantitationPeakDocuments = this.database.getQuantitationPeaks(this.quantitationCompoundDocument);
            this.getTableViewer().setInput((Object)quantitationPeakDocuments);
        } else {
            this.getTableViewer().setInput(null);
        }
    }

    private void addButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        GridData gridDataButtons = new GridData(1040);
        gridDataButtons.verticalAlignment = 128;
        composite.setLayoutData((Object)gridDataButtons);
        this.addButtonRemove(composite);
        this.addButtonRemoveAll(composite);
        this.addButtonCreate(composite);
    }

    private void addButtonRemove(Composite parent) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)new GridData(768));
        button.setText("Delete");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IQuantitationPeakMSD quantitationPeakDocument = QuantitationPeaksListUI.this.getSelectedQuantitationPeak();
                if (QuantitationPeaksListUI.this.quantitationCompoundDocument != null && quantitationPeakDocument != null && QuantitationPeaksListUI.this.database != null) {
                    QuantitationPeaksListUI.this.database.deleteQuantitationPeakDocument(QuantitationPeaksListUI.this.quantitationCompoundDocument, quantitationPeakDocument);
                    QuantitationPeaksListUI.this.triggerCompoundDocumentUpdateEvent();
                }
            }
        });
    }

    private void addButtonRemoveAll(Composite parent) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)new GridData(768));
        button.setText("Delete All");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HashSet quantitationPeakDocuments = new HashSet(QuantitationPeaksListUI.this.getSelectedQuantitationPeaks());
                if (QuantitationPeaksListUI.this.quantitationCompoundDocument != null && quantitationPeakDocuments != null && QuantitationPeaksListUI.this.database != null) {
                    QuantitationPeaksListUI.this.database.deleteQuantitationPeakDocuments(QuantitationPeaksListUI.this.quantitationCompoundDocument, quantitationPeakDocuments);
                    QuantitationPeaksListUI.this.triggerCompoundDocumentUpdateEvent();
                }
            }
        });
    }

    private void addButtonCreate(Composite parent) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)new GridData(768));
        button.setText("Create Response Table");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (QuantitationPeaksListUI.this.database != null) {
                    List quantitationPeakDocuments = QuantitationPeaksListUI.this.database.getQuantitationPeaks(QuantitationPeaksListUI.this.quantitationCompoundDocument);
                    if (quantitationPeakDocuments.size() > 0) {
                        if (QuantitationPeaksListUI.this.showQuestion(QuantitationPeaksListUI.MESSAGE_BOX_TEXT, "Would you like to create new concentration response and signal tables?") == 64) {
                            IQuantitationCompoundMSD quantitationCompoundMSD = QuantitationPeaksListUI.this.quantitationCompoundDocument;
                            ArrayList<QuantitationPeakMSD> quantitationPeaks = new ArrayList<QuantitationPeakMSD>();
                            for (IQuantitationPeakMSD quantitationPeakDocument : quantitationPeakDocuments) {
                                IPeakMSD referencePeakMSD = quantitationPeakDocument.getReferencePeakMSD();
                                double concentration = quantitationPeakDocument.getConcentration();
                                String concentrationUnit = quantitationPeakDocument.getConcentrationUnit();
                                QuantitationPeakMSD quantitationPeakMSD = new QuantitationPeakMSD(referencePeakMSD, concentration, concentrationUnit);
                                quantitationPeaks.add(quantitationPeakMSD);
                            }
                            quantitationCompoundMSD.calculateQuantitationSignalsAndConcentrationResponseEntries(quantitationPeaks);
                            QuantitationPeaksListUI.this.triggerCompoundDocumentUpdateEvent();
                        }
                    } else {
                        QuantitationPeaksListUI.this.showMessage(QuantitationPeaksListUI.MESSAGE_BOX_TEXT, "There are no quantitation peaks stored.");
                    }
                }
            }
        });
    }

    private void triggerCompoundDocumentUpdateEvent() {
        if (this.eventBroker != null && this.quantitationCompoundDocument != null && this.database != null) {
            this.map.clear();
            this.map.put("QuantitationCompoundDocument", this.quantitationCompoundDocument);
            this.map.put("Database", this.database);
            this.eventBroker.send("quantitation/msd/update/supplier/chemclipse/quantitationcompounddocument", this.map);
        }
    }

    private IQuantitationPeakMSD getSelectedQuantitationPeak() {
        IQuantitationPeakMSD quantitationPeakDocument = null;
        Object element = this.getSelectedTableItem();
        if (element instanceof IQuantitationPeakMSD) {
            quantitationPeakDocument = (IQuantitationPeakMSD)element;
        }
        return quantitationPeakDocument;
    }

    private List<IQuantitationPeakMSD> getSelectedQuantitationPeaks() {
        ArrayList<IQuantitationPeakMSD> quantitationPeakDocuments = new ArrayList<IQuantitationPeakMSD>();
        List<Object> elements = this.getSelectedTableItems();
        for (Object element : elements) {
            if (!(element instanceof IQuantitationPeakMSD)) continue;
            IQuantitationPeakMSD quantitationPeakDocument = (IQuantitationPeakMSD)element;
            quantitationPeakDocuments.add(quantitationPeakDocument);
        }
        return quantitationPeakDocuments;
    }
}

