/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.io.DataOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.executor.cache.CacheUtil;
import org.eclipse.birt.data.engine.executor.cache.MemoryCache;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.cache.SizeOfUtil;
import org.eclipse.birt.data.engine.executor.cache.disk.SimpleDiskCache;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.StringTable;
import org.eclipse.birt.data.engine.impl.index.IAuxiliaryIndexCreator;
import org.eclipse.birt.data.engine.impl.index.IIndexSerializer;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class SimpleSmartCache
implements ResultSetCache {
    private ResultSetCache resultSetCache;
    private boolean isOpen = false;
    private IEventHandler eventHandler;
    private int count;
    private long usedMemorySize;
    private long memoryCacheSize;
    private List<IResultObject> resultObjectsList;
    private IResultClass rsMeta;
    private SizeOfUtil sizeOfUtil;
    private int maxRows;
    private SimpleDiskCache diskCache;
    private static Logger logger = Logger.getLogger(SimpleSmartCache.class.getName());
    private DataEngineSession session;

    public SimpleSmartCache(DataEngineSession session, IEventHandler eventHandler, IResultClass rsMeta) throws DataException {
        this.session = session;
        this.eventHandler = eventHandler;
        this.count = 0;
        this.usedMemorySize = 0L;
        this.memoryCacheSize = CacheUtil.computeMemoryBufferSize(eventHandler.getAppContext());
        this.resultObjectsList = new ArrayList<IResultObject>();
        this.rsMeta = rsMeta;
        this.sizeOfUtil = new SizeOfUtil(rsMeta);
        this.maxRows = CacheUtil.getMaxRows(eventHandler.getAppContext());
    }

    public void add(IResultObject odaObject) throws DataException {
        if (this.memoryCacheSize == 0L || this.usedMemorySize < this.memoryCacheSize) {
            ++this.count;
            if (this.maxRows > 0 && this.count > this.maxRows) {
                throw new DataException("data.engine.exceed.max.data.object.row");
            }
            this.addToMemoryCache(odaObject);
        } else {
            ++this.count;
            this.addToDiskCache(odaObject);
        }
    }

    private void addToDiskCache(IResultObject odaObject) throws DataException {
        this.addToMemoryCache(odaObject);
        IResultObject[] resultObjects = this.resultObjectsList.toArray(new IResultObject[0]);
        this.resultObjectsList.clear();
        if (this.diskCache == null) {
            this.diskCache = new SimpleDiskCache(resultObjects, this.rsMeta, resultObjects.length, this.maxRows, this.session);
        }
        this.diskCache.add(resultObjects);
    }

    private void addToMemoryCache(IResultObject odaObject) throws DataException {
        int metaFieldCount;
        int odaObjectFieldCount = odaObject.getResultClass().getFieldCount();
        if (odaObjectFieldCount < (metaFieldCount = this.rsMeta.getFieldCount())) {
            Object[] obs = new Object[metaFieldCount];
            int i = 1;
            while (i <= odaObjectFieldCount) {
                obs[i - 1] = odaObject.getFieldValue(i);
                ++i;
            }
            odaObject = new ResultObject(this.rsMeta, obs);
        }
        this.resultObjectsList.add(odaObject);
        if (this.memoryCacheSize != 0L) {
            this.usedMemorySize += (long)this.sizeOfUtil.sizeOf(odaObject);
        }
    }

    @Override
    public int getCount() throws DataException {
        this.open();
        return this.resultSetCache.getCount();
    }

    public void open() {
        if (!this.isOpen) {
            if (this.diskCache == null) {
                logger.fine("MemoryCache is used");
                IResultObject[] resultObjects = this.resultObjectsList.toArray(new IResultObject[0]);
                this.resultSetCache = new MemoryCache(resultObjects, this.rsMeta, null);
            } else {
                logger.fine("DisckCache is used");
                this.resultSetCache = this.diskCache;
            }
            this.isOpen = true;
        }
    }

    @Override
    public int getCurrentIndex() throws DataException {
        this.open();
        return this.resultSetCache.getCurrentIndex();
    }

    @Override
    public IResultObject getCurrentResult() throws DataException {
        this.open();
        return this.resultSetCache.getCurrentResult();
    }

    @Override
    public boolean next() throws DataException {
        this.open();
        return this.resultSetCache.next();
    }

    @Override
    public IResultObject fetch() throws DataException {
        this.open();
        return this.resultSetCache.fetch();
    }

    @Override
    public void moveTo(int destIndex) throws DataException {
        this.open();
        this.resultSetCache.moveTo(destIndex);
    }

    @Override
    public void reset() throws DataException {
        this.open();
        this.resultSetCache.reset();
    }

    @Override
    public void close() throws DataException {
        this.open();
        this.resultSetCache.close();
        this.resultSetCache = null;
        this.isOpen = false;
    }

    @Override
    public void doSave(DataOutputStream outputStream, DataOutputStream rowLensStream, Map<String, StringTable> stringTable, Map<String, IIndexSerializer> index, List<IBinding> cacheRequestMap, int version, List<IAuxiliaryIndexCreator> auxiliaryIndexCreators, boolean saveRowId) throws DataException {
        this.open();
        this.resultSetCache.doSave(outputStream, rowLensStream, stringTable, index, cacheRequestMap, version, auxiliaryIndexCreators, saveRowId);
    }

    @Override
    public void incrementalUpdate(OutputStream outputStream, OutputStream rowLensStream, int originalRowCount, Map<String, StringTable> stringTable, Map<String, IIndexSerializer> map, List<IBinding> cacheRequestMap, int version, List<IAuxiliaryIndexCreator> auxiliaryIndexCreators) throws DataException {
        this.open();
        this.resultSetCache.incrementalUpdate(outputStream, rowLensStream, originalRowCount, stringTable, map, cacheRequestMap, version, auxiliaryIndexCreators);
    }

    @Override
    public void setResultClass(IResultClass rsMeta) throws DataException {
        this.open();
        this.resultSetCache.setResultClass(rsMeta);
    }
}

