/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.refactoring.actions.RenameJavaElementAction;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionCommandHandler;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.correction.ICommandAccess;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class RenameRefactoringProposal
implements IJavaCompletionProposal,
ICompletionProposalExtension6,
ICommandAccess {
    private final String fLabel;
    private int fRelevance;
    private final JavaEditor fEditor;

    public RenameRefactoringProposal(JavaEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        this.fLabel = CorrectionMessages.RenameRefactoringProposal_name;
        this.fRelevance = 8;
    }

    public void apply(IDocument document) {
        RenameJavaElementAction renameAction = new RenameJavaElementAction(this.fEditor);
        renameAction.doRun();
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return CorrectionMessages.RenameRefactoringProposal_additionalInfo;
    }

    public String getDisplayString() {
        String shortCutString = CorrectionCommandHandler.getShortCutString(this.getCommandId());
        if (shortCutString != null) {
            return Messages.format(CorrectionMessages.ChangeCorrectionProposal_name_with_shortcut, new String[]{this.fLabel, shortCutString});
        }
        return this.fLabel;
    }

    public StyledString getStyledDisplayString() {
        StyledString str = new StyledString(this.fLabel);
        String shortCutString = CorrectionCommandHandler.getShortCutString(this.getCommandId());
        if (shortCutString != null) {
            String decorated = Messages.format(CorrectionMessages.ChangeCorrectionProposal_name_with_shortcut, new String[]{this.fLabel, shortCutString});
            return StyledCellLabelProvider.styleDecoratedString((String)decorated, (StyledString.Styler)StyledString.QUALIFIER_STYLER, (StyledString)str);
        }
        return str;
    }

    public Image getImage() {
        return JavaPluginImages.get("org.eclipse.jdt.ui.correction_linked_rename.gif");
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public String getCommandId() {
        return "org.eclipse.jdt.ui.edit.text.java.rename.element";
    }

    public void setRelevance(int relevance) {
        this.fRelevance = relevance;
    }
}

