/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.text.java.correction;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.ui.text.java.correction.CUCorrectionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.TextEdit;

public class ASTRewriteCorrectionProposal
extends CUCorrectionProposal {
    private ASTRewrite fRewrite;
    private ImportRewrite fImportRewrite;

    public ASTRewriteCorrectionProposal(String name, ICompilationUnit cu, ASTRewrite rewrite, int relevance, Image image) {
        super(name, cu, relevance, image);
        this.fRewrite = rewrite;
    }

    public ASTRewriteCorrectionProposal(String name, ICompilationUnit cu, ASTRewrite rewrite, int relevance) {
        this(name, cu, rewrite, relevance, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
    }

    public ImportRewrite getImportRewrite() {
        return this.fImportRewrite;
    }

    public void setImportRewrite(ImportRewrite rewrite) {
        this.fImportRewrite = rewrite;
    }

    public ImportRewrite createImportRewrite(CompilationUnit astRoot) {
        this.fImportRewrite = StubUtility.createImportRewrite(astRoot, true);
        return this.fImportRewrite;
    }

    protected void addEdits(IDocument document, TextEdit editRoot) throws CoreException {
        super.addEdits(document, editRoot);
        ASTRewrite rewrite = this.getRewrite();
        if (rewrite != null) {
            try {
                TextEdit edit = rewrite.rewriteAST();
                editRoot.addChild(edit);
            }
            catch (IllegalArgumentException e) {
                throw new CoreException(JavaUIStatus.createError(4, e));
            }
        }
        if (this.fImportRewrite != null) {
            editRoot.addChild(this.fImportRewrite.rewriteImports((IProgressMonitor)new NullProgressMonitor()));
        }
    }

    protected ASTRewrite getRewrite() throws CoreException {
        if (this.fRewrite == null) {
            IStatus status = JavaUIStatus.createError(4, "Rewrite not initialized", null);
            throw new CoreException(status);
        }
        return this.fRewrite;
    }
}

