/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.comparator;

import java.util.Comparator;
import org.eclipse.chemclipse.model.comparator.SortOrder;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;

public class TargetMatchFactorComparator
implements Comparator<IIdentificationTarget> {
    private SortOrder sortOrder;

    public TargetMatchFactorComparator() {
        this.sortOrder = SortOrder.ASC;
    }

    public TargetMatchFactorComparator(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    @Override
    public int compare(IIdentificationTarget identificationTarget1, IIdentificationTarget identificationTarget2) {
        int returnValue;
        if (identificationTarget1 == null || identificationTarget1.getComparisonResult() == null) {
            return 0;
        }
        if (identificationTarget2 == null || identificationTarget2.getComparisonResult() == null) {
            return 0;
        }
        float matchFactor1 = identificationTarget1.getComparisonResult().getMatchFactor();
        float matchFactor2 = identificationTarget2.getComparisonResult().getMatchFactor();
        switch (this.sortOrder) {
            case ASC: {
                returnValue = Float.compare(matchFactor1, matchFactor2);
                break;
            }
            case DESC: {
                returnValue = Float.compare(matchFactor2, matchFactor1);
                break;
            }
            default: {
                returnValue = 0;
            }
        }
        return returnValue;
    }
}

