/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.comparison.math;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.comparison.math.IMatchCalculator;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.msd.model.xic.IIonRange;

public class GeometricDistanceCalculator
implements IMatchCalculator {
    @Override
    public float calculate(IScanMSD unknown, IScanMSD reference) {
        List<Integer> ionList = this.getIonList(unknown);
        double sqrtSquaredIntensitiesU = this.calculateSqrtSumSquaredIntensities(unknown, ionList);
        double sqrtSquaredIntensitiesR = this.calculateSqrtSumSquaredIntensities(reference, ionList);
        if (sqrtSquaredIntensitiesU == 0.0 || sqrtSquaredIntensitiesR == 0.0) {
            return 0.0f;
        }
        IExtractedIonSignal extractedIonSignalU = unknown.getExtractedIonSignal();
        IExtractedIonSignal extractedIonSignalR = reference.getExtractedIonSignal();
        return this.calculate(sqrtSquaredIntensitiesU, sqrtSquaredIntensitiesR, extractedIonSignalU, extractedIonSignalR, ionList);
    }

    @Override
    public float calculate(IScanMSD unknown, IScanMSD reference, IIonRange ionRange) {
        List<Integer> ionList = this.getIonList(ionRange);
        double sqrtSquaredIntensitiesU = this.calculateSqrtSumSquaredIntensities(unknown, ionList);
        double sqrtSquaredIntensitiesR = this.calculateSqrtSumSquaredIntensities(reference, ionList);
        if (sqrtSquaredIntensitiesU == 0.0 || sqrtSquaredIntensitiesR == 0.0) {
            return 0.0f;
        }
        int startIon = ionRange.getStartIon();
        int stopIon = ionRange.getStopIon();
        IExtractedIonSignal extractedIonSignalU = unknown.getExtractedIonSignal((double)startIon, (double)stopIon);
        IExtractedIonSignal extractedIonSignalR = reference.getExtractedIonSignal((double)startIon, (double)stopIon);
        return this.calculate(sqrtSquaredIntensitiesU, sqrtSquaredIntensitiesR, extractedIonSignalU, extractedIonSignalR, ionList);
    }

    private float calculate(double sqrtSquaredIntensitiesU, double sqrtSquaredIntensitiesR, IExtractedIonSignal extractedIonSignalU, IExtractedIonSignal extractedIonSignalR, List<Integer> ionList) {
        double sumDistance = 0.0;
        for (int ion : ionList) {
            double uValue = (double)extractedIonSignalU.getAbundance(ion) / sqrtSquaredIntensitiesU;
            double rValue = (double)extractedIonSignalR.getAbundance(ion) / sqrtSquaredIntensitiesR;
            sumDistance += Math.pow(uValue - rValue, 2.0);
        }
        return (float)Math.pow(sumDistance += 1.0, -1.0);
    }

    private double calculateSumSquaredIntensities(IScanMSD massSpectrum, List<Integer> ions) {
        double normalizedLength = 0.0;
        IExtractedIonSignal signal = massSpectrum.getExtractedIonSignal();
        for (int ion : ions) {
            normalizedLength += Math.pow(signal.getAbundance(ion), 2.0);
        }
        return normalizedLength;
    }

    private double calculateSqrtSumSquaredIntensities(IScanMSD massSpectrum, List<Integer> ions) {
        return Math.sqrt(this.calculateSumSquaredIntensities(massSpectrum, ions));
    }

    private List<Integer> getIonList(IIonRange ionRange) {
        ArrayList<Integer> ionList = new ArrayList<Integer>();
        int startIon = ionRange.getStartIon();
        int stopIon = ionRange.getStopIon();
        int ion = startIon;
        while (ion <= stopIon) {
            ionList.add(ion);
            ++ion;
        }
        return ionList;
    }

    private List<Integer> getIonList(IScanMSD massSpectrum) {
        ArrayList<Integer> ionList = new ArrayList<Integer>();
        IExtractedIonSignal signal = massSpectrum.getExtractedIonSignal();
        int startIon = signal.getStartIon();
        int stopIon = signal.getStopIon();
        int ion = startIon;
        while (ion <= stopIon) {
            if (signal.getAbundance(ion) > 0.0f) {
                ionList.add(ion);
            }
            ++ion;
        }
        return ionList;
    }
}

