/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui;

import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class AntImageDescriptor
extends CompositeImageDescriptor {
    public static final int HAS_ERRORS = 1;
    public static final int IMPORTED = 2;
    public static final int HAS_WARNINGS = 4;
    private ImageDescriptor fBaseImage;
    private int fFlags;
    private Point fSize;

    public AntImageDescriptor(ImageDescriptor baseImage, int flags) {
        this.setBaseImage(baseImage);
        this.setFlags(flags);
    }

    protected Point getSize() {
        if (this.fSize == null) {
            ImageData data = this.getBaseImage().getImageData();
            this.setSize(new Point(data.width, data.height));
        }
        return this.fSize;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AntImageDescriptor)) {
            return false;
        }
        AntImageDescriptor other = (AntImageDescriptor)((Object)object);
        return this.getBaseImage().equals(other.getBaseImage()) && this.getFlags() == other.getFlags();
    }

    public int hashCode() {
        return this.getBaseImage().hashCode() | this.getFlags();
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.getBaseImage().getImageData();
        if (bg == null) {
            bg = DEFAULT_IMAGE_DATA;
        }
        this.drawImage(bg, 0, 0);
        this.drawOverlays();
    }

    protected void drawOverlays() {
        int flags = this.getFlags();
        int y = 0;
        ImageData data = null;
        if ((flags & 2) != 0) {
            data = AntUIImages.getImageDescriptor("org.eclipse.ant.ui.ovrImport").getImageData();
            this.drawImage(data, 0, 0);
        }
        if ((flags & 1) != 0) {
            y = this.getSize().y;
            data = AntUIImages.getImageDescriptor("org.eclipse.ant.ui.ovrError").getImageData();
            this.drawImage(data, 0, y -= data.height);
        } else if ((flags & 4) != 0) {
            y = this.getSize().y;
            data = AntUIImages.getImageDescriptor("org.eclipse.ant.ui.ovrWarning").getImageData();
            this.drawImage(data, 0, y -= data.height);
        }
    }

    protected ImageDescriptor getBaseImage() {
        return this.fBaseImage;
    }

    protected void setBaseImage(ImageDescriptor baseImage) {
        this.fBaseImage = baseImage;
    }

    protected int getFlags() {
        return this.fFlags;
    }

    protected void setFlags(int flags) {
        this.fFlags = flags;
    }

    protected void setSize(Point size) {
        this.fSize = size;
    }
}

