/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.support;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.model.IPeakIntegrationEntry;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.support.IdentificationSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.peaks.IPeakIntegratorSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.peaks.PeakIntegrator;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.exceptions.NoIntegratorAvailableException;
import org.eclipse.chemclipse.logging.core.Logger;

public class IntegrationSupport {
    private static final Logger logger = Logger.getLogger(IdentificationSupport.class);
    public static final String NOT_AVAILABLE = "n.a.";

    public String[] getIntegratorNames(String[] integratorIds) {
        int size = integratorIds.length;
        String[] processorNames = new String[size];
        int index = 0;
        while (index < size) {
            processorNames[index] = this.getIntegratorName(integratorIds[index]);
            ++index;
        }
        return processorNames;
    }

    public String getIntegratorName(IPeakIntegrationEntry entry) {
        return this.getIntegratorName(entry.getProcessorId());
    }

    public String getIntegratorName(String integratorId) {
        String processorName = NOT_AVAILABLE;
        try {
            IPeakIntegratorSupplier integratorSupplier = PeakIntegrator.getPeakIntegratorSupport().getIntegratorSupplier(integratorId);
            processorName = integratorSupplier.getIntegratorName();
        }
        catch (NoIntegratorAvailableException e) {
            logger.warn((Object)e);
        }
        return processorName;
    }

    public String[] getPluginIds() {
        String[] pluginIds = new String[]{NOT_AVAILABLE};
        try {
            List ids = PeakIntegrator.getPeakIntegratorSupport().getAvailableIntegratorIds();
            pluginIds = ids.toArray(new String[ids.size()]);
        }
        catch (NoIntegratorAvailableException e) {
            logger.warn((Object)e);
        }
        return pluginIds;
    }

    public String getIntegratorId(String name) {
        String[] integratorIds = this.getPluginIds();
        String[] integratorNames = this.getIntegratorNames(integratorIds);
        int index = 0;
        String[] stringArray = integratorNames;
        int n = integratorNames.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            if (entry.equals(name)) {
                return integratorIds[index];
            }
            ++index;
            ++n2;
        }
        return "";
    }
}

