/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.converter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.xic.ExtractedIonSignalExtractor;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignals;
import org.eclipse.chemclipse.msd.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.numeric.statistics.Calculations;
import org.eclipse.chemclipse.swt.ui.support.PlotSeries;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class ConverterMSD {
    private static final Logger logger = Logger.getLogger(ConverterMSD.class);

    private ConverterMSD() {
    }

    public static List<IIon> getFilteredIons(IScanMSD massSpectrum) {
        ArrayList<IIon> ions;
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        boolean filterMassSpectrum = preferences.getBoolean("filterMassSpectrum", false);
        int filterLimitIons = preferences.getInt("filterLimitIons", 8000);
        int numberOfIons = massSpectrum.getNumberOfIons();
        if (filterMassSpectrum && numberOfIons > filterLimitIons) {
            ions = new ArrayList<IIon>();
            float[] intensities = new float[massSpectrum.getIons().size()];
            int i = 0;
            for (IIon ion : massSpectrum.getIons()) {
                intensities[i++] = ion.getAbundance();
            }
            float maxIntensity = Calculations.getMax((float[])intensities);
            float medianIntensity = Calculations.getMedian((float[])intensities);
            float limitIntensity = medianIntensity + (maxIntensity - medianIntensity) / 6.0f;
            int moduloValue = numberOfIons / 100;
            int j = 0;
            for (IIon ion : massSpectrum.getIons()) {
                float intensity = ion.getAbundance();
                if (intensity >= limitIntensity) {
                    ions.add(ion);
                } else if (moduloValue > 0 && j % moduloValue == 0) {
                    ions.add(ion);
                }
                ++j;
            }
        } else {
            ions = massSpectrum.getIons();
        }
        return ions;
    }

    public static PlotSeries convertChromatogram(IChromatogramMSD chromatogram, IMarkedIons selectedIons) {
        PlotSeries chromatogramSeries = null;
        if (chromatogram != null && selectedIons != null) {
            try {
                ExtractedIonSignalExtractor extractedIonSignalExtractor = new ExtractedIonSignalExtractor(chromatogram);
                IExtractedIonSignals signals = extractedIonSignalExtractor.getExtractedIonSignals();
                int scans = signals.size();
                double[] xSeries = new double[scans];
                double[] ySeries = new double[scans];
                int x = 0;
                int y = 0;
                for (IExtractedIonSignal signal : signals.getExtractedIonSignals()) {
                    xSeries[x++] = signal.getRetentionTime();
                    double abundance = 0.0;
                    Iterator iterator = selectedIons.getIonsNominal().iterator();
                    while (iterator.hasNext()) {
                        int ion = (Integer)iterator.next();
                        abundance += (double)signal.getAbundance(ion);
                    }
                    ySeries[y++] = abundance;
                }
                signals = null;
                chromatogramSeries = new PlotSeries(xSeries, ySeries);
            }
            catch (ChromatogramIsNullException e) {
                logger.warn((Object)e);
            }
        }
        return chromatogramSeries;
    }

    public static List<PlotSeries> convertIons(IChromatogramMSD chromatogram, IMarkedIons selectedIons) {
        ArrayList<PlotSeries> plotSeriesList = new ArrayList<PlotSeries>();
        if (chromatogram != null && selectedIons != null) {
            try {
                ExtractedIonSignalExtractor extractedIonSignalExtractor = new ExtractedIonSignalExtractor(chromatogram);
                IExtractedIonSignals signals = extractedIonSignalExtractor.getExtractedIonSignals();
                int scans = signals.size();
                Iterator iterator = selectedIons.getIonsNominal().iterator();
                while (iterator.hasNext()) {
                    int ion = (Integer)iterator.next();
                    double[] xSeries = new double[scans];
                    double[] ySeries = new double[scans];
                    int x = 0;
                    int y = 0;
                    for (IExtractedIonSignal signal : signals.getExtractedIonSignals()) {
                        xSeries[x++] = signal.getRetentionTime();
                        ySeries[y++] = signal.getAbundance(ion);
                    }
                    PlotSeries ionSeries = new PlotSeries(xSeries, ySeries);
                    plotSeriesList.add(ionSeries);
                }
            }
            catch (ChromatogramIsNullException e) {
                logger.warn((Object)e);
            }
        }
        return plotSeriesList;
    }

    public static PlotSeries convertMassSpectrum(IScanMSD massSpectrum) {
        PlotSeries massSpectrumSeries = null;
        if (massSpectrum != null) {
            IExtractedIonSignal extractedIonSignal = massSpectrum.getExtractedIonSignal();
            int startIon = extractedIonSignal.getStartIon() - 1;
            int stopIon = extractedIonSignal.getStopIon() + 1;
            int ions = stopIon - startIon + 1;
            double[] xSeries = new double[ions];
            double[] ySeries = new double[ions];
            int x = 0;
            int y = 0;
            int ion = startIon;
            while (ion <= stopIon) {
                xSeries[x++] = ion;
                ySeries[y++] = extractedIonSignal.getAbundance(ion);
                ++ion;
            }
            massSpectrumSeries = new PlotSeries(xSeries, ySeries);
        }
        return massSpectrumSeries;
    }

    public static PlotSeries convertPeak(IChromatogramPeakMSD peak) {
        PlotSeries peakSeries = null;
        if (peak != null) {
            IPeakModelMSD peakModel = peak.getPeakModel();
            int size = peakModel.getRetentionTimes().size();
            double[] xSeries = new double[size];
            double[] ySeries = new double[size];
            int x = 0;
            int y = 0;
            Iterator iterator = peakModel.getRetentionTimes().iterator();
            while (iterator.hasNext()) {
                int retentionTime = (Integer)iterator.next();
                xSeries[x++] = retentionTime;
                ySeries[y++] = peakModel.getPeakAbundance(retentionTime);
            }
            peakSeries = new PlotSeries(xSeries, ySeries);
        }
        return peakSeries;
    }

    public static List<PlotSeries> convertPeaks(List<IChromatogramPeakMSD> peaks) {
        ArrayList<PlotSeries> plotSeries = null;
        if (peaks != null) {
            plotSeries = new ArrayList<PlotSeries>();
            for (IChromatogramPeakMSD peak : peaks) {
                PlotSeries peakSeries = ConverterMSD.convertPeak(peak);
                plotSeries.add(peakSeries);
            }
        }
        return plotSeries;
    }
}

