/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import org.eclipse.chemclipse.chromatogram.msd.process.model.ChromatogramProcessEntry;
import org.eclipse.chemclipse.chromatogram.msd.process.model.IChromatogramProcessEntry;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.internal.filter.BatchProcessJobEventFilter;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.io.IBatchProcessJobReader;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.model.BatchProcessJob;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.model.IBatchProcessJob;
import org.eclipse.chemclipse.chromatogram.xxd.report.model.ChromatogramReportSupplierEntry;
import org.eclipse.chemclipse.chromatogram.xxd.report.model.IChromatogramReportSupplierEntry;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.converter.model.ChromatogramInputEntry;
import org.eclipse.chemclipse.converter.model.ChromatogramOutputEntry;
import org.eclipse.chemclipse.converter.model.IChromatogramInputEntry;
import org.eclipse.chemclipse.converter.model.IChromatogramOutputEntry;
import org.eclipse.core.runtime.IProgressMonitor;

public class BatchProcessJobReader
implements IBatchProcessJobReader {
    @Override
    public IBatchProcessJob read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        BatchProcessJob batchProcessJob = new BatchProcessJob();
        try {
            this.readHeader(file, batchProcessJob);
            this.readChromatogramInputEntries(file, batchProcessJob, monitor);
            this.readChromatogramProcessEntries(file, batchProcessJob, monitor);
            this.readChromatogramOutputEntries(file, batchProcessJob, monitor);
            this.readChromatogramReportEntries(file, batchProcessJob, monitor);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        return batchProcessJob;
    }

    private void readHeader(File file, IBatchProcessJob batchProcessJob) throws XMLStreamException, IOException {
        XMLInputFactory.newInstance().setProperty("javax.xml.stream.isCoalescing", true);
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        XMLEventReader eventReader = inputFactory.createXMLEventReader(bufferedInputStream, "UTF-8");
        while (eventReader.hasNext()) {
            String elementName;
            XMLEvent event = eventReader.nextEvent();
            if (event.isStartElement()) {
                elementName = event.asStartElement().getName().getLocalPart();
                continue;
            }
            if (event.isEndElement() && (elementName = event.asEndElement().getName().getLocalPart()).equals("Header")) break;
        }
        eventReader.close();
        bufferedInputStream.close();
    }

    private void readChromatogramInputEntries(File file, IBatchProcessJob batchProcessJob, IProgressMonitor monitor) throws XMLStreamException, IOException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        XMLEventReader eventReader = inputFactory.createXMLEventReader(bufferedInputStream, "UTF-8");
        ArrayList<String> acceptedElements = new ArrayList<String>();
        acceptedElements.add("InputEntry");
        BatchProcessJobEventFilter eventFilter = new BatchProcessJobEventFilter(acceptedElements);
        XMLEventReader filteredEventReader = inputFactory.createFilteredReader(eventReader, eventFilter);
        while (filteredEventReader.hasNext()) {
            XMLEvent event = filteredEventReader.nextEvent();
            event = eventReader.nextEvent();
            ChromatogramInputEntry inputEntry = new ChromatogramInputEntry(event.asCharacters().getData());
            batchProcessJob.getChromatogramInputEntries().add((IChromatogramInputEntry)inputEntry);
        }
        eventReader.close();
        bufferedInputStream.close();
    }

    private void readChromatogramProcessEntries(File file, IBatchProcessJob batchProcessJob, IProgressMonitor monitor) throws XMLStreamException, IOException {
        String processCategory = null;
        String processorId = "";
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        XMLEventReader eventReader = inputFactory.createXMLEventReader(bufferedInputStream, "UTF-8");
        ArrayList<String> acceptedElements = new ArrayList<String>();
        acceptedElements.add("ProcessEntry");
        BatchProcessJobEventFilter eventFilter = new BatchProcessJobEventFilter(acceptedElements);
        XMLEventReader filteredEventReader = inputFactory.createFilteredReader(eventReader, eventFilter);
        while (filteredEventReader.hasNext()) {
            XMLEvent event = filteredEventReader.nextEvent();
            Iterator<Attribute> attributes = event.asStartElement().getAttributes();
            while (attributes.hasNext()) {
                Attribute attribute = attributes.next();
                String attributeName = attribute.getName().getLocalPart();
                if (attributeName.equals("processorType")) {
                    processCategory = attribute.getValue();
                }
                if (!attributeName.equals("processorId")) continue;
                processorId = attribute.getValue();
            }
            ChromatogramProcessEntry processEntry = new ChromatogramProcessEntry(processCategory, processorId);
            batchProcessJob.getChromatogramProcessEntries().add((IChromatogramProcessEntry)processEntry);
        }
        eventReader.close();
        bufferedInputStream.close();
    }

    private void readChromatogramOutputEntries(File file, IBatchProcessJob batchProcessJob, IProgressMonitor monitor) throws XMLStreamException, IOException {
        String converterId = "";
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        XMLEventReader eventReader = inputFactory.createXMLEventReader(bufferedInputStream, "UTF-8");
        ArrayList<String> acceptedElements = new ArrayList<String>();
        acceptedElements.add("OutputEntry");
        BatchProcessJobEventFilter eventFilter = new BatchProcessJobEventFilter(acceptedElements);
        XMLEventReader filteredEventReader = inputFactory.createFilteredReader(eventReader, eventFilter);
        while (filteredEventReader.hasNext()) {
            XMLEvent event = filteredEventReader.nextEvent();
            Iterator<Attribute> attributes = event.asStartElement().getAttributes();
            while (attributes.hasNext()) {
                Attribute attribute = attributes.next();
                String attributeName = attribute.getName().getLocalPart();
                if (!attributeName.equals("converterId")) continue;
                converterId = attribute.getValue();
            }
            event = eventReader.nextEvent();
            String outputFolder = event.asCharacters().getData();
            ChromatogramOutputEntry outputEntry = new ChromatogramOutputEntry(outputFolder, converterId);
            batchProcessJob.getChromatogramOutputEntries().add((IChromatogramOutputEntry)outputEntry);
        }
        eventReader.close();
        bufferedInputStream.close();
    }

    private void readChromatogramReportEntries(File file, IBatchProcessJob batchProcessJob, IProgressMonitor monitor) throws XMLStreamException, IOException {
        String reportSupplierId = "";
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        XMLEventReader eventReader = inputFactory.createXMLEventReader(bufferedInputStream, "UTF-8");
        ArrayList<String> acceptedElements = new ArrayList<String>();
        acceptedElements.add("ReportEntry");
        BatchProcessJobEventFilter eventFilter = new BatchProcessJobEventFilter(acceptedElements);
        XMLEventReader filteredEventReader = inputFactory.createFilteredReader(eventReader, eventFilter);
        while (filteredEventReader.hasNext()) {
            XMLEvent event = filteredEventReader.nextEvent();
            Iterator<Attribute> attributes = event.asStartElement().getAttributes();
            while (attributes.hasNext()) {
                Attribute attribute = attributes.next();
                String attributeName = attribute.getName().getLocalPart();
                if (!attributeName.equals("reportSupplierId")) continue;
                reportSupplierId = attribute.getValue();
            }
            event = eventReader.nextEvent();
            String reportFolderOrFile = event.asCharacters().getData();
            ChromatogramReportSupplierEntry reportEntry = new ChromatogramReportSupplierEntry(reportFolderOrFile, reportSupplierId);
            batchProcessJob.getChromatogramReportEntries().add((IChromatogramReportSupplierEntry)reportEntry);
        }
        eventReader.close();
        bufferedInputStream.close();
    }
}

