/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowIdAccessor;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;
import org.eclipse.nebula.widgets.nattable.selection.IRowSelectionModel;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.event.RowSelectionEvent;
import org.eclipse.swt.graphics.Rectangle;

public class RowSelectionModel<R>
implements IRowSelectionModel<R> {
    protected final SelectionLayer selectionLayer;
    protected final IRowDataProvider<R> rowDataProvider;
    protected final IRowIdAccessor<R> rowIdAccessor;
    private boolean multipleSelectionAllowed;
    protected Map<Serializable, R> selectedRows;
    protected Rectangle lastSelectedRange;
    protected Set<Serializable> lastSelectedRowIds;
    protected final ReadWriteLock selectionsLock;

    public RowSelectionModel(SelectionLayer selectionLayer, IRowDataProvider<R> rowDataProvider, IRowIdAccessor<R> rowIdAccessor) {
        this(selectionLayer, rowDataProvider, rowIdAccessor, true);
    }

    public RowSelectionModel(SelectionLayer selectionLayer, IRowDataProvider<R> rowDataProvider, IRowIdAccessor<R> rowIdAccessor, boolean multipleSelectionAllowed) {
        this.selectionLayer = selectionLayer;
        this.rowDataProvider = rowDataProvider;
        this.rowIdAccessor = rowIdAccessor;
        this.multipleSelectionAllowed = multipleSelectionAllowed;
        this.selectedRows = new HashMap<Serializable, R>();
        this.selectionsLock = new ReentrantReadWriteLock();
    }

    @Override
    public boolean isMultipleSelectionAllowed() {
        return this.multipleSelectionAllowed;
    }

    @Override
    public void setMultipleSelectionAllowed(boolean multipleSelectionAllowed) {
        this.multipleSelectionAllowed = multipleSelectionAllowed;
    }

    @Override
    public void addSelection(int columnPosition, int rowPosition) {
        this.selectionsLock.writeLock().lock();
        try {
            R rowObject;
            if (!this.multipleSelectionAllowed) {
                this.selectedRows.clear();
            }
            if ((rowObject = this.getRowObjectByPosition(rowPosition)) != null) {
                Serializable rowId = this.rowIdAccessor.getRowId(rowObject);
                this.selectedRows.put(rowId, rowObject);
            }
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    @Override
    public void addSelection(Rectangle range) {
        this.selectionsLock.writeLock().lock();
        try {
            if (!this.multipleSelectionAllowed) {
                this.selectedRows.clear();
                range.height = 1;
            }
            HashMap<Serializable, R> rowsToSelect = new HashMap<Serializable, R>();
            int maxY = Math.min(range.y + range.height, this.selectionLayer.getRowCount());
            int rowPosition = range.y;
            while (rowPosition < maxY) {
                R rowObject = this.getRowObjectByPosition(rowPosition);
                if (rowObject != null) {
                    Serializable rowId = this.rowIdAccessor.getRowId(rowObject);
                    rowsToSelect.put(rowId, rowObject);
                }
                ++rowPosition;
            }
            this.selectedRows.putAll(rowsToSelect);
            this.lastSelectedRowIds = range.equals((Object)this.lastSelectedRange) ? rowsToSelect.keySet() : null;
            this.lastSelectedRange = range;
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    @Override
    public void clearSelection() {
        this.selectionsLock.writeLock().lock();
        try {
            this.selectedRows.clear();
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    @Override
    public void clearSelection(int columnPosition, int rowPosition) {
        this.selectionsLock.writeLock().lock();
        try {
            Serializable rowId = this.getRowIdByPosition(rowPosition);
            this.selectedRows.remove(rowId);
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    @Override
    public void clearSelection(Rectangle removedSelection) {
        this.selectionsLock.writeLock().lock();
        try {
            int maxY = Math.min(removedSelection.y + removedSelection.height, this.selectionLayer.getRowCount());
            int rowPosition = removedSelection.y;
            while (rowPosition < maxY) {
                this.clearSelection(0, rowPosition);
                ++rowPosition;
            }
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    @Override
    public void clearSelection(R rowObject) {
        this.selectionsLock.writeLock().lock();
        try {
            this.selectedRows.remove(this.rowIdAccessor.getRowId(rowObject));
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.selectionsLock.readLock().lock();
        try {
            boolean bl = this.selectedRows.isEmpty();
            return bl;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public List<Rectangle> getSelections() {
        ArrayList<Rectangle> selectionRectangles = new ArrayList<Rectangle>();
        this.selectionsLock.readLock().lock();
        try {
            int width = this.selectionLayer.getColumnCount();
            for (Serializable rowId : this.selectedRows.keySet()) {
                int rowPosition = this.getRowPositionById(rowId);
                selectionRectangles.add(new Rectangle(0, rowPosition, width, 1));
            }
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
        return selectionRectangles;
    }

    @Override
    public boolean isCellPositionSelected(int columnPosition, int rowPosition) {
        int cellOriginRowPosition;
        ILayerCell cell = this.selectionLayer.getCellByPosition(columnPosition, rowPosition);
        int testRowPosition = cellOriginRowPosition = cell.getOriginRowPosition();
        while (testRowPosition < cellOriginRowPosition + cell.getRowSpan()) {
            if (this.isRowPositionSelected(testRowPosition)) {
                return true;
            }
            ++testRowPosition;
        }
        return false;
    }

    @Override
    public int[] getSelectedColumnPositions() {
        if (!this.isEmpty()) {
            int columnCount;
            this.selectionsLock.readLock().lock();
            try {
                columnCount = this.selectionLayer.getColumnCount();
            }
            finally {
                this.selectionsLock.readLock().unlock();
            }
            int[] columns = new int[columnCount];
            int i = 0;
            while (i < columnCount) {
                columns[i] = i;
                ++i;
            }
            return columns;
        }
        return new int[0];
    }

    @Override
    public boolean isColumnPositionSelected(int columnPosition) {
        this.selectionsLock.readLock().lock();
        try {
            boolean bl = !this.selectedRows.isEmpty();
            return bl;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public int[] getFullySelectedColumnPositions(int fullySelectedColumnRowCount) {
        this.selectionsLock.readLock().lock();
        try {
            if (this.isColumnPositionFullySelected(0, fullySelectedColumnRowCount)) {
                int[] nArray = this.getSelectedColumnPositions();
                return nArray;
            }
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
        return new int[0];
    }

    @Override
    public boolean isColumnPositionFullySelected(int columnPosition, int fullySelectedColumnRowCount) {
        this.selectionsLock.readLock().lock();
        try {
            int selectedRowCount = this.selectedRows.size();
            if (selectedRowCount == 0) {
                return false;
            }
            boolean bl = selectedRowCount == fullySelectedColumnRowCount;
            return bl;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public List<R> getSelectedRowObjects() {
        ArrayList<R> rowObjects = new ArrayList<R>();
        this.selectionsLock.readLock().lock();
        try {
            rowObjects.addAll(this.selectedRows.values());
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
        return rowObjects;
    }

    @Override
    public int getSelectedRowCount() {
        this.selectionsLock.readLock().lock();
        try {
            int n = this.selectedRows.size();
            return n;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public Set<Range> getSelectedRowPositions() {
        HashSet<Range> selectedRowRanges = new HashSet<Range>();
        this.selectionsLock.readLock().lock();
        try {
            for (Serializable rowId : this.selectedRows.keySet()) {
                int rowPosition = this.getRowPositionById(rowId);
                selectedRowRanges.add(new Range(rowPosition, rowPosition + 1));
            }
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
        return selectedRowRanges;
    }

    @Override
    public boolean isRowPositionSelected(int rowPosition) {
        this.selectionsLock.readLock().lock();
        try {
            Serializable rowId = this.getRowIdByPosition(rowPosition);
            boolean bl = this.selectedRows.containsKey(rowId);
            return bl;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public int[] getFullySelectedRowPositions(int rowWidth) {
        this.selectionsLock.readLock().lock();
        try {
            int selectedRowCount = this.selectedRows.size();
            int[] selectedRowPositions = new int[selectedRowCount];
            int i = 0;
            for (Serializable rowId : this.selectedRows.keySet()) {
                selectedRowPositions[i] = this.getRowPositionById(rowId);
                ++i;
            }
            int[] nArray = selectedRowPositions;
            return nArray;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public boolean isRowPositionFullySelected(int rowPosition, int rowWidth) {
        return this.isRowPositionSelected(rowPosition);
    }

    private Serializable getRowIdByPosition(int rowPosition) {
        R rowObject = this.getRowObjectByPosition(rowPosition);
        if (rowObject != null) {
            Serializable rowId = this.rowIdAccessor.getRowId(rowObject);
            return rowId;
        }
        return null;
    }

    private R getRowObjectByPosition(int rowPosition) {
        block6: {
            this.selectionsLock.readLock().lock();
            try {
                R r;
                int rowIndex = this.selectionLayer.getRowIndexByPosition(rowPosition);
                if (rowIndex < 0) break block6;
                try {
                    R rowObject;
                    r = rowObject = this.rowDataProvider.getRowObject(rowIndex);
                }
                catch (Exception exception) {
                    break block6;
                }
                return r;
            }
            finally {
                this.selectionsLock.readLock().unlock();
            }
        }
        return null;
    }

    private int getRowPositionById(Serializable rowId) {
        this.selectionsLock.readLock().lock();
        try {
            int rowPosition;
            R rowObject = this.selectedRows.get(rowId);
            int rowIndex = this.rowDataProvider.indexOfRowObject(rowObject);
            if (rowIndex == -1) {
                return -1;
            }
            int n = rowPosition = this.selectionLayer.getRowPositionByIndex(rowIndex);
            return n;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public void handleLayerEvent(IStructuralChangeEvent event) {
        if (event.isVerticalStructureChanged()) {
            ArrayList<Serializable> keysToRemove = new ArrayList<Serializable>();
            for (Map.Entry<Serializable, R> entry : this.selectedRows.entrySet()) {
                int rowIndex = this.rowDataProvider.indexOfRowObject(entry.getValue());
                if (rowIndex != -1) continue;
                keysToRemove.add(entry.getKey());
            }
            this.selectionsLock.readLock().lock();
            try {
                for (Serializable toRemove : keysToRemove) {
                    this.selectedRows.remove(toRemove);
                }
            }
            finally {
                this.selectionsLock.readLock().unlock();
            }
            if (!keysToRemove.isEmpty()) {
                HashSet<Integer> rowPositions = new HashSet<Integer>();
                Collection<StructuralDiff> diffs = event.getRowDiffs();
                if (diffs != null) {
                    for (StructuralDiff rowDiff : diffs) {
                        if (rowDiff.getDiffType() == null || !rowDiff.getDiffType().equals((Object)StructuralDiff.DiffTypeEnum.DELETE)) continue;
                        Range beforePositionRange = rowDiff.getBeforePositionRange();
                        int i = beforePositionRange.start;
                        while (i < beforePositionRange.end) {
                            rowPositions.add(i);
                            ++i;
                        }
                    }
                }
                this.selectionLayer.fireLayerEvent(new RowSelectionEvent(this.selectionLayer, rowPositions, -1));
            }
        }
    }

    @Override
    public Class<IStructuralChangeEvent> getLayerEventClass() {
        return IStructuralChangeEvent.class;
    }
}

