/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.rcp.app.ui.toolcontrols;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ActivePerspective {
    @Inject
    private Composite parent;
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EventHandler eventHandler;

    @PostConstruct
    private void createControl() {
        this.parent.setLayout((Layout)new GridLayout(1, true));
        final Label label = new Label(this.parent, 0);
        this.setPerspectiveLabel(label, this.getActiveInitialPerspective());
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 0x1000000;
        gridData.minimumWidth = 300;
        label.setLayoutData((Object)gridData);
        if (this.eventBroker != null) {
            this.eventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    String perspectiveName = (String)event.getProperty("org.eclipse.e4.data");
                    ActivePerspective.this.setPerspectiveLabel(label, perspectiveName);
                }
            };
            this.eventBroker.subscribe("application/select/perspective", this.eventHandler);
        }
    }

    private void setPerspectiveLabel(Label label, String perspectiveName) {
        perspectiveName = perspectiveName.replaceAll("<", "");
        perspectiveName = perspectiveName.replaceAll(">", "");
        label.setText("Perspective: " + perspectiveName);
    }

    @PreDestroy
    private void preDestroy() {
        if (this.eventBroker != null) {
            this.eventBroker.unsubscribe(this.eventHandler);
        }
    }

    private String getActiveInitialPerspective() {
        List perspectiveStacks = this.modelService.findElements((MUIElement)this.application, null, MPerspectiveStack.class, null);
        if (perspectiveStacks.size() > 0) {
            MPerspectiveStack perspectiveStack = (MPerspectiveStack)perspectiveStacks.get(0);
            return ((MPerspective)perspectiveStack.getSelectedElement()).getLabel();
        }
        return "n.a.";
    }
}

