/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.implementation;

import java.util.ArrayList;
import org.apache.commons.math3.analysis.function.Gaussian;
import org.eclipse.chemclipse.model.core.IPeakIntensityValues;
import org.eclipse.chemclipse.model.exceptions.PeakException;
import org.eclipse.chemclipse.model.implementation.PeakIntensityValues;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.implementation.IntegrationEntryMSD;
import org.eclipse.chemclipse.msd.model.implementation.PeakMSD;
import org.eclipse.chemclipse.msd.model.implementation.PeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.implementation.PeakModelMSD;

public class GaussianPeakMSDFactory {
    private static final float RATIO_OF_RETENTION_TIME_TO_CONSIDER = 0.005f;
    private static final double NORMALIZATION_VALUE = 1000.0;
    private static final double ION_VALUE = 18.0;
    private static final String INTEGRATOR_DESCRIPTION = "Gaussian Peak generator";

    private GaussianPeakMSDFactory() {
    }

    public static IPeakMSD createGaussianPeakMSD(IChromatogramMSD chromatogramMSD, float height, int retentionTime, float startBackgroundAbundance, float stopBackgroundAbundance) throws IllegalArgumentException, PeakException {
        if (chromatogramMSD == null) {
            throw new PeakException("The chromatogram must not be null.");
        }
        int scanNumber = chromatogramMSD.getScanNumber(retentionTime);
        int retentionTimeRange = (int)(0.005f * (float)retentionTime);
        if (retentionTimeRange % 2 == 1) {
            ++retentionTimeRange;
        }
        Gaussian gaussian = new Gaussian(1000.0, (double)retentionTime, (double)retentionTimeRange);
        PeakIntensityValues peakIntensities = new PeakIntensityValues(height);
        int rt = retentionTime - 3 * retentionTimeRange;
        while (rt <= retentionTime + 3 * retentionTimeRange) {
            peakIntensities.addIntensityValue(rt, (float)gaussian.value((double)rt));
            rt += retentionTimeRange / 2;
        }
        peakIntensities.normalize();
        IVendorMassSpectrum vendorMassSpectrum = chromatogramMSD.getSupplierScan(scanNumber);
        PeakModelMSD peakModelMSD = new PeakModelMSD(new PeakMassSpectrum(vendorMassSpectrum), (IPeakIntensityValues)peakIntensities, startBackgroundAbundance, stopBackgroundAbundance);
        return new PeakMSD(peakModelMSD);
    }

    public static IPeakMSD createGaussianPeakMSD(IChromatogramMSD chromatogramMSD, float height, double area, int retentionTime, float startBackgroundAbundance, float stopBackgroundAbundance, float retentionIndex, int setRetentionTimeColumn1, int setRetentionTimeColumn2) throws IllegalArgumentException, PeakException {
        if (chromatogramMSD == null) {
            throw new PeakException("The chromatogram must not be null.");
        }
        int scanNumber = chromatogramMSD.getScanNumber(retentionTime);
        int retentionTimeRange = (int)(0.005f * (float)retentionTime);
        if (retentionTimeRange % 2 == 1) {
            ++retentionTimeRange;
        }
        Gaussian gaussian = new Gaussian(1000.0, (double)retentionTime, (double)retentionTimeRange);
        PeakIntensityValues peakIntensities = new PeakIntensityValues(height);
        int rt = retentionTime - 3 * retentionTimeRange;
        while (rt <= retentionTime + 3 * retentionTimeRange) {
            peakIntensities.addIntensityValue(rt, (float)gaussian.value((double)rt));
            rt += retentionTimeRange / 2;
        }
        peakIntensities.normalize();
        IVendorMassSpectrum vendorMassSpectrum = chromatogramMSD.getSupplierScan(scanNumber);
        PeakMassSpectrum peakMassSpectrum = new PeakMassSpectrum(vendorMassSpectrum);
        peakMassSpectrum.setRetentionIndex(retentionIndex);
        peakMassSpectrum.setRetentionTimeColumn1(setRetentionTimeColumn1);
        peakMassSpectrum.setRetentionTimeColumn2(setRetentionTimeColumn2);
        PeakModelMSD peakModelMSD = new PeakModelMSD(peakMassSpectrum, (IPeakIntensityValues)peakIntensities, startBackgroundAbundance, stopBackgroundAbundance);
        IntegrationEntryMSD integrationEntry = new IntegrationEntryMSD(18.0, area);
        ArrayList<IntegrationEntryMSD> integrationEntries = new ArrayList<IntegrationEntryMSD>();
        integrationEntries.add(integrationEntry);
        PeakMSD peakMSD = new PeakMSD(peakModelMSD);
        peakMSD.setIntegratedArea(integrationEntries, INTEGRATOR_DESCRIPTION);
        return peakMSD;
    }
}

