/*
 * Decompiled with CFR 0.152.
 */
package org.ejml;

import java.util.Arrays;
import java.util.Comparator;
import org.ejml.data.DenseMatrix64F;

public class UtilEjml {
    public static String VERSION = "0.27";
    public static double TOLERANCE = 1.0E-8;
    public static double EPS = Math.pow(2.0, -52.0);

    public static boolean isUncountable(double val) {
        return Double.isNaN(val) || Double.isInfinite(val);
    }

    public static void memset(double[] data, double val) {
        int i = 0;
        while (i < data.length) {
            data[i] = val;
            ++i;
        }
    }

    public static void memset(double[] data, double val, int length) {
        int i = 0;
        while (i < length) {
            data[i] = val;
            ++i;
        }
    }

    public static void memset(int[] data, int val, int length) {
        int i = 0;
        while (i < length) {
            data[i] = val;
            ++i;
        }
    }

    public static <T> void setnull(T[] array) {
        int i = 0;
        while (i < array.length) {
            array[i] = null;
            ++i;
        }
    }

    public static double max(double[] array, int start, int length) {
        double max = array[start];
        int end = start + length;
        int i = start + 1;
        while (i < end) {
            double v = array[i];
            if (v > max) {
                max = v;
            }
            ++i;
        }
        return max;
    }

    public static DenseMatrix64F parseMatrix(String s, int numColumns) {
        String[] vals = s.split("(\\s)+");
        int start = vals[0].isEmpty() ? 1 : 0;
        int numRows = (vals.length - start) / numColumns;
        DenseMatrix64F ret = new DenseMatrix64F(numRows, numColumns);
        int index = start;
        int i = 0;
        while (i < numRows) {
            int j = 0;
            while (j < numColumns) {
                ret.set(i, j, Double.parseDouble(vals[index++]));
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public static Integer[] sortByIndex(final double[] data, int size) {
        Integer[] idx = new Integer[size];
        int i = 0;
        while (i < size) {
            idx[i] = i;
            ++i;
        }
        Arrays.sort(idx, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return Double.compare(data[o1], data[o2]);
            }
        });
        return idx;
    }
}

