/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.lu;

import org.ejml.UtilEjml;
import org.ejml.alg.dense.decomposition.TriangularSolver;
import org.ejml.data.Complex64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.interfaces.decomposition.LUDecomposition;
import org.ejml.ops.CommonOps;
import org.ejml.ops.SpecializedOps;

public abstract class LUDecompositionBase_D64
implements LUDecomposition<DenseMatrix64F> {
    protected DenseMatrix64F LU;
    protected int maxWidth = -1;
    protected int m;
    protected int n;
    protected double[] dataLU;
    protected double[] vv;
    protected int[] indx;
    protected int[] pivot;
    protected double pivsign;
    Complex64F det = new Complex64F();

    public void setExpectedMaxSize(int numRows, int numCols) {
        this.LU = new DenseMatrix64F(numRows, numCols);
        this.dataLU = this.LU.data;
        this.maxWidth = Math.max(numRows, numCols);
        this.vv = new double[this.maxWidth];
        this.indx = new int[this.maxWidth];
        this.pivot = new int[this.maxWidth];
    }

    public DenseMatrix64F getLU() {
        return this.LU;
    }

    public int[] getIndx() {
        return this.indx;
    }

    public int[] getPivot() {
        return this.pivot;
    }

    @Override
    public boolean inputModified() {
        return false;
    }

    @Override
    public DenseMatrix64F getLower(DenseMatrix64F lower) {
        int j;
        int numCols;
        int numRows = this.LU.numRows;
        int n = numCols = this.LU.numRows < this.LU.numCols ? this.LU.numRows : this.LU.numCols;
        if (lower == null) {
            lower = new DenseMatrix64F(numRows, numCols);
        } else {
            if (lower.numCols != numCols || lower.numRows != numRows) {
                throw new IllegalArgumentException("Unexpected matrix dimension");
            }
            CommonOps.fill(lower, 0.0);
        }
        int i = 0;
        while (i < numCols) {
            lower.set(i, i, 1.0);
            j = 0;
            while (j < i) {
                lower.set(i, j, this.LU.get(i, j));
                ++j;
            }
            ++i;
        }
        if (numRows > numCols) {
            i = numCols;
            while (i < numRows) {
                j = 0;
                while (j < numCols) {
                    lower.set(i, j, this.LU.get(i, j));
                    ++j;
                }
                ++i;
            }
        }
        return lower;
    }

    @Override
    public DenseMatrix64F getUpper(DenseMatrix64F upper) {
        int numRows = this.LU.numRows < this.LU.numCols ? this.LU.numRows : this.LU.numCols;
        int numCols = this.LU.numCols;
        if (upper == null) {
            upper = new DenseMatrix64F(numRows, numCols);
        } else {
            if (upper.numCols != numCols || upper.numRows != numRows) {
                throw new IllegalArgumentException("Unexpected matrix dimension");
            }
            CommonOps.fill(upper, 0.0);
        }
        int i = 0;
        while (i < numRows) {
            int j = i;
            while (j < numCols) {
                upper.set(i, j, this.LU.get(i, j));
                ++j;
            }
            ++i;
        }
        return upper;
    }

    @Override
    public DenseMatrix64F getPivot(DenseMatrix64F pivot) {
        return SpecializedOps.pivotMatrix(pivot, this.pivot, this.LU.numRows, false);
    }

    protected void decomposeCommonInit(DenseMatrix64F a) {
        if (a.numRows > this.maxWidth || a.numCols > this.maxWidth) {
            this.setExpectedMaxSize(a.numRows, a.numCols);
        }
        this.m = a.numRows;
        this.n = a.numCols;
        this.LU.set(a);
        int i = 0;
        while (i < this.m) {
            this.pivot[i] = i;
            ++i;
        }
        this.pivsign = 1.0;
    }

    @Override
    public boolean isSingular() {
        int i = 0;
        while (i < this.m) {
            if (Math.abs(this.dataLU[i * this.n + i]) < UtilEjml.EPS) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public Complex64F computeDeterminant() {
        if (this.m != this.n) {
            throw new IllegalArgumentException("Must be a square matrix.");
        }
        double ret = this.pivsign;
        int total = this.m * this.n;
        int i = 0;
        while (i < total) {
            ret *= this.dataLU[i];
            i += this.n + 1;
        }
        this.det.real = ret;
        this.det.imaginary = 0.0;
        return this.det;
    }

    public double quality() {
        return SpecializedOps.qualityTriangular(this.LU);
    }

    public void _solveVectorInternal(double[] vv) {
        int ii = 0;
        int i = 0;
        while (i < this.n) {
            int ip = this.indx[i];
            double sum = vv[ip];
            vv[ip] = vv[i];
            if (ii != 0) {
                int index = i * this.n + ii - 1;
                int j = ii - 1;
                while (j < i) {
                    sum -= this.dataLU[index++] * vv[j];
                    ++j;
                }
            } else if (sum != 0.0) {
                ii = i + 1;
            }
            vv[i] = sum;
            ++i;
        }
        TriangularSolver.solveU(this.dataLU, vv, this.n);
    }

    public double[] _getVV() {
        return this.vv;
    }
}

