/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import org.ejml.UtilEjml;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.ops.CommonOps;
import org.ejml.ops.MatrixFeatures;
import org.ejml.ops.SingularOps;

public class NormOps {
    public static void normalizeF(DenseMatrix64F A) {
        double val = NormOps.normF(A);
        if (val == 0.0) {
            return;
        }
        int size = A.getNumElements();
        int i = 0;
        while (i < size) {
            A.div(i, val);
            ++i;
        }
    }

    public static double conditionP(DenseMatrix64F A, double p) {
        if (p == 2.0) {
            return NormOps.conditionP2(A);
        }
        if (A.numRows == A.numCols) {
            DenseMatrix64F A_inv = new DenseMatrix64F(A.numRows, A.numCols);
            if (!CommonOps.invert(A, A_inv)) {
                throw new IllegalArgumentException("A can't be inverted.");
            }
            return NormOps.normP(A, p) * NormOps.normP(A_inv, p);
        }
        DenseMatrix64F pinv = new DenseMatrix64F(A.numCols, A.numRows);
        CommonOps.pinv(A, pinv);
        return NormOps.normP(A, p) * NormOps.normP(pinv, p);
    }

    public static double conditionP2(DenseMatrix64F A) {
        SingularValueDecomposition<DenseMatrix64F> svd = DecompositionFactory.svd(A.numRows, A.numCols, false, false, true);
        svd.decompose(A);
        double[] singularValues = svd.getSingularValues();
        int n = SingularOps.rank(svd, 1.0E-12);
        if (n == 0) {
            return 0.0;
        }
        double smallest = Double.MAX_VALUE;
        double largest = Double.MIN_VALUE;
        double[] dArray = singularValues;
        int n2 = singularValues.length;
        int n3 = 0;
        while (n3 < n2) {
            double s = dArray[n3];
            if (s < smallest) {
                smallest = s;
            }
            if (s > largest) {
                largest = s;
            }
            ++n3;
        }
        return largest / smallest;
    }

    public static double fastNormF(D1Matrix64F a) {
        double total = 0.0;
        int size = a.getNumElements();
        int i = 0;
        while (i < size) {
            double val = a.get(i);
            total += val * val;
            ++i;
        }
        return Math.sqrt(total);
    }

    public static double normF(D1Matrix64F a) {
        double total = 0.0;
        double scale = CommonOps.elementMaxAbs(a);
        if (scale == 0.0) {
            return 0.0;
        }
        int size = a.getNumElements();
        int i = 0;
        while (i < size) {
            double val = a.get(i) / scale;
            total += val * val;
            ++i;
        }
        return scale * Math.sqrt(total);
    }

    public static double elementP(RowD1Matrix64F A, double p) {
        if (p == 1.0) {
            return CommonOps.elementSumAbs(A);
        }
        if (p == 2.0) {
            return NormOps.normF(A);
        }
        double max = CommonOps.elementMaxAbs(A);
        if (max == 0.0) {
            return 0.0;
        }
        double total = 0.0;
        int size = A.getNumElements();
        int i = 0;
        while (i < size) {
            double a = A.get(i) / max;
            total += Math.pow(Math.abs(a), p);
            ++i;
        }
        return max * Math.pow(total, 1.0 / p);
    }

    public static double fastElementP(D1Matrix64F A, double p) {
        if (p == 2.0) {
            return NormOps.fastNormF(A);
        }
        double total = 0.0;
        int size = A.getNumElements();
        int i = 0;
        while (i < size) {
            double a = A.get(i);
            total += Math.pow(Math.abs(a), p);
            ++i;
        }
        return Math.pow(total, 1.0 / p);
    }

    public static double normP(DenseMatrix64F A, double p) {
        if (p == 1.0) {
            return NormOps.normP1(A);
        }
        if (p == 2.0) {
            return NormOps.normP2(A);
        }
        if (Double.isInfinite(p)) {
            return NormOps.normPInf(A);
        }
        if (MatrixFeatures.isVector(A)) {
            return NormOps.elementP(A, p);
        }
        throw new IllegalArgumentException("Doesn't support induced norms yet.");
    }

    public static double fastNormP(DenseMatrix64F A, double p) {
        if (p == 1.0) {
            return NormOps.normP1(A);
        }
        if (p == 2.0) {
            return NormOps.fastNormP2(A);
        }
        if (Double.isInfinite(p)) {
            return NormOps.normPInf(A);
        }
        if (MatrixFeatures.isVector(A)) {
            return NormOps.fastElementP(A, p);
        }
        throw new IllegalArgumentException("Doesn't support induced norms yet.");
    }

    public static double normP1(DenseMatrix64F A) {
        if (MatrixFeatures.isVector(A)) {
            return CommonOps.elementSumAbs(A);
        }
        return NormOps.inducedP1(A);
    }

    public static double normP2(DenseMatrix64F A) {
        if (MatrixFeatures.isVector(A)) {
            return NormOps.normF(A);
        }
        return NormOps.inducedP2(A);
    }

    public static double fastNormP2(DenseMatrix64F A) {
        if (MatrixFeatures.isVector(A)) {
            return NormOps.fastNormF(A);
        }
        return NormOps.inducedP2(A);
    }

    public static double normPInf(DenseMatrix64F A) {
        if (MatrixFeatures.isVector(A)) {
            return CommonOps.elementMaxAbs(A);
        }
        return NormOps.inducedPInf(A);
    }

    public static double inducedP1(DenseMatrix64F A) {
        double max = 0.0;
        int m = A.numRows;
        int n = A.numCols;
        int j = 0;
        while (j < n) {
            double total = 0.0;
            int i = 0;
            while (i < m) {
                total += Math.abs(A.get(i, j));
                ++i;
            }
            if (total > max) {
                max = total;
            }
            ++j;
        }
        return max;
    }

    public static double inducedP2(DenseMatrix64F A) {
        SingularValueDecomposition<DenseMatrix64F> svd = DecompositionFactory.svd(A.numRows, A.numCols, false, false, true);
        if (!svd.decompose(A)) {
            throw new RuntimeException("Decomposition failed");
        }
        double[] singularValues = svd.getSingularValues();
        return UtilEjml.max(singularValues, 0, singularValues.length);
    }

    public static double inducedPInf(DenseMatrix64F A) {
        double max = 0.0;
        int m = A.numRows;
        int n = A.numCols;
        int i = 0;
        while (i < m) {
            double total = 0.0;
            int j = 0;
            while (j < n) {
                total += Math.abs(A.get(i, j));
                ++j;
            }
            if (total > max) {
                max = total;
            }
            ++i;
        }
        return max;
    }
}

