/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.identifier.peak.PeakIdentifier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.processing.IPeakIdentifierProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.core.IPeakIdentificationBatchProcess;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.internal.report.PeakReport;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.model.IPeakIdentificationBatchJob;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.model.IPeakInputEntry;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.model.IPeakOutputEntry;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.processing.IPeakIdentificationProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.processing.PeakIdentificationProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.report.IPeakIdentificationBatchProcessReport;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.report.PeakIdentificationBatchProcessReport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.peaks.PeakIntegrator;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.processing.IPeakIntegratorProcessingInfo;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeaks;
import org.eclipse.chemclipse.model.implementation.Peaks;
import org.eclipse.chemclipse.msd.converter.peak.PeakConverterMSD;
import org.eclipse.chemclipse.msd.converter.processing.peak.IPeakExportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.converter.processing.peak.IPeakImportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakIdentificationBatchProcess
implements IPeakIdentificationBatchProcess {
    private static final Logger logger = Logger.getLogger(PeakIdentificationBatchProcess.class);

    @Override
    public IPeakIdentificationProcessingInfo execute(IPeakIdentificationBatchJob peakIdentificationBatchJob, IProgressMonitor monitor) {
        PeakIdentificationProcessingInfo processingInfo = new PeakIdentificationProcessingInfo();
        ArrayList<IPeakMSD> peaks = new ArrayList<IPeakMSD>();
        PeakIdentificationBatchProcessReport batchProcessReport = new PeakIdentificationBatchProcessReport();
        if (peakIdentificationBatchJob == null) {
            return null;
        }
        for (IPeakInputEntry inputEntry : peakIdentificationBatchJob.getPeakInputEntries()) {
            try {
                File peakInputFile = new File(inputEntry.getInputFile());
                IPeakImportConverterProcessingInfo processingPeakImportConverterInfo = this.loadPeaksFromFile(peakInputFile, monitor);
                processingInfo.addMessages((IProcessingInfo)processingPeakImportConverterInfo);
                try {
                    IPeaks peakImports = processingPeakImportConverterInfo.getPeaks();
                    for (IPeak peak : peakImports.getPeaks()) {
                        if (!(peak instanceof IPeakMSD)) continue;
                        peaks.add((IPeakMSD)peak);
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)e);
                }
            }
            catch (Exception e) {
                logger.warn((Object)e);
                ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "Batch Process Peaks", "Something has completely gone wrong with the file: " + inputEntry.getInputFile());
                processingInfo.addMessage((IProcessingMessage)processingMessage);
            }
        }
        IPeakIdentificationProcessingInfo peakIdentificationProcessingInfo = this.processPeaks(peaks, peakIdentificationBatchJob, batchProcessReport, monitor);
        processingInfo.addMessages(peakIdentificationProcessingInfo);
        peakIdentificationProcessingInfo = this.exportPeaks(peaks, peakIdentificationBatchJob, monitor);
        processingInfo.addMessages(peakIdentificationProcessingInfo);
        this.reportTheResults(peakIdentificationBatchJob, batchProcessReport, monitor);
        processingInfo.setPeakIdentificationBatchProcessReport(batchProcessReport);
        return processingInfo;
    }

    private IPeakImportConverterProcessingInfo loadPeaksFromFile(File peakInputFile, IProgressMonitor monitor) {
        return PeakConverterMSD.convert((File)peakInputFile, (IProgressMonitor)monitor);
    }

    private IPeakIdentificationProcessingInfo processPeaks(List<IPeakMSD> peaks, IPeakIdentificationBatchJob peakIdentificationBatchJob, IPeakIdentificationBatchProcessReport batchProcessReport, IProgressMonitor monitor) {
        PeakIdentificationProcessingInfo peakIdentificationProcessingInfo = new PeakIdentificationProcessingInfo();
        String integratorId = peakIdentificationBatchJob.getPeakIntegrationEntry().getProcessorId();
        IPeakIntegratorProcessingInfo processingInfoIntegrator = PeakIntegrator.integrate(peaks, (String)integratorId, (IProgressMonitor)monitor);
        peakIdentificationProcessingInfo.addMessages((IProcessingInfo)processingInfoIntegrator);
        String identifierId = peakIdentificationBatchJob.getPeakIdentificationEntry().getProcessorId();
        IPeakIdentifierProcessingInfo processingInfoIdentifier = PeakIdentifier.identify(peaks, (String)identifierId, (IProgressMonitor)monitor);
        peakIdentificationProcessingInfo.addMessages((IProcessingInfo)processingInfoIdentifier);
        IPeaks reportPeaks = batchProcessReport.getPeaks();
        for (IPeakMSD peak : peaks) {
            reportPeaks.addPeak((IPeak)peak);
        }
        return peakIdentificationProcessingInfo;
    }

    private IPeakIdentificationProcessingInfo exportPeaks(List<IPeakMSD> peakList, IPeakIdentificationBatchJob peakIdentificationBatchJob, IProgressMonitor monitor) {
        PeakIdentificationProcessingInfo peakIdentificationProcessingInfo = new PeakIdentificationProcessingInfo();
        List<IPeakOutputEntry> outputEntries = peakIdentificationBatchJob.getPeakOutputEntries();
        for (IPeakOutputEntry outputEntry : outputEntries) {
            String converterId = outputEntry.getConverterId();
            String outputFolder = outputEntry.getOutputFolder();
            if (!outputFolder.endsWith(File.separator)) {
                outputFolder = String.valueOf(outputFolder) + File.separator;
            }
            File peakOutputFile = new File(String.valueOf(outputFolder) + peakIdentificationBatchJob.getName());
            IPeaks peaks = this.getPeaksInstance(peakList);
            IPeakExportConverterProcessingInfo processingInfo = PeakConverterMSD.convert((File)peakOutputFile, (IPeaks)peaks, (boolean)false, (String)converterId, (IProgressMonitor)monitor);
            peakIdentificationProcessingInfo.addMessages((IProcessingInfo)processingInfo);
        }
        return peakIdentificationProcessingInfo;
    }

    private IPeaks getPeaksInstance(List<IPeakMSD> peakList) {
        Peaks peaks = new Peaks();
        for (IPeakMSD peak : peakList) {
            peaks.addPeak((IPeak)peak);
        }
        return peaks;
    }

    private void reportTheResults(IPeakIdentificationBatchJob peakIdentificationBatchJob, IPeakIdentificationBatchProcessReport batchProcessReport, IProgressMonitor monitor) {
        File results;
        String folder = peakIdentificationBatchJob.getReportFolder();
        if (!folder.endsWith(File.separator)) {
            folder = String.valueOf(folder) + File.separator;
        }
        String file = String.valueOf(folder) + peakIdentificationBatchJob.getName();
        if (peakIdentificationBatchJob.isOverrideReport()) {
            results = new File(file);
            if (results.exists()) {
                results.delete();
            }
        } else {
            Date now = new Date();
            file = String.valueOf(file) + " - " + now.toString().replace(":", "");
            results = new File(file);
        }
        try {
            PrintWriter printWriter = new PrintWriter(results, "UTF-8");
            IPeaks peaks = batchProcessReport.getPeaks();
            String integrator = peakIdentificationBatchJob.getPeakIntegrationEntry().getProcessorId();
            String identifier = peakIdentificationBatchJob.getPeakIdentificationEntry().getProcessorId();
            PeakReport.writeResults(peaks, printWriter, integrator, identifier);
            printWriter.flush();
            printWriter.close();
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)e);
        }
        catch (UnsupportedEncodingException e) {
            logger.warn((Object)e);
        }
    }
}

