/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.io;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.IQuantDatabase;
import org.eclipse.chemclipse.model.core.IIntegrationEntry;
import org.eclipse.chemclipse.model.core.RetentionIndexType;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.quantitation.IQuantitationEntry;
import org.eclipse.chemclipse.model.quantitation.IRetentionIndexWindow;
import org.eclipse.chemclipse.model.quantitation.IRetentionTimeWindow;
import org.eclipse.chemclipse.model.targets.IPeakTarget;
import org.eclipse.chemclipse.msd.model.core.IIntegrationEntryMSD;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IIonTransition;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.msd.model.core.IRegularMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.identifier.massspectrum.IMassSpectrumTarget;
import org.eclipse.chemclipse.msd.model.core.quantitation.IConcentrationResponseEntriesMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IConcentrationResponseEntryMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationCompoundMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationEntryMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationPeakMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationSignalMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationSignalsMSD;

public class QuantDatabaseWriter {
    public static void write(IQuantDatabase quantDatabase, File file) throws Exception {
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
        List<IQuantitationCompoundMSD> quantitationCompounds = quantDatabase.getQuantitationCompounds();
        dataOutputStream.writeInt(quantitationCompounds.size());
        for (IQuantitationCompoundMSD quantitationCompound : quantitationCompounds) {
            QuantDatabaseWriter.writeString(dataOutputStream, quantitationCompound.getName());
            QuantDatabaseWriter.writeString(dataOutputStream, quantitationCompound.getConcentrationUnit());
            QuantDatabaseWriter.writeString(dataOutputStream, quantitationCompound.getCalibrationMethod().toString());
            QuantDatabaseWriter.writeString(dataOutputStream, quantitationCompound.getChemicalClass());
            dataOutputStream.writeBoolean(quantitationCompound.isCrossZero());
            dataOutputStream.writeBoolean(quantitationCompound.isUseTIC());
            List<IQuantitationPeakMSD> quantitationPeaks = quantDatabase.getQuantitationPeaks(quantitationCompound);
            QuantDatabaseWriter.writeQuantitationPeaks(dataOutputStream, quantitationPeaks);
            IConcentrationResponseEntriesMSD concentrationResponseEntriesMSD = quantitationCompound.getConcentrationResponseEntriesMSD();
            QuantDatabaseWriter.writeConcentrationResponseEntries(dataOutputStream, concentrationResponseEntriesMSD);
            IQuantitationSignalsMSD quantitationSignalsMSD = quantitationCompound.getQuantitationSignalsMSD();
            QuantDatabaseWriter.writeQuantitationSignals(dataOutputStream, quantitationSignalsMSD);
            IRetentionIndexWindow retentionIndexWindow = quantitationCompound.getRetentionIndexWindow();
            QuantDatabaseWriter.writeRetentionIndexWindow(dataOutputStream, retentionIndexWindow);
            IRetentionTimeWindow retentionTimeWindow = quantitationCompound.getRetentionTimeWindow();
            QuantDatabaseWriter.writeRetentionTimeWindow(dataOutputStream, retentionTimeWindow);
        }
    }

    private static void writeQuantitationPeaks(DataOutputStream dataOutputStream, List<IQuantitationPeakMSD> quantitationPeaks) throws Exception {
        dataOutputStream.writeInt(quantitationPeaks.size());
        for (IQuantitationPeakMSD quantitationPeak : quantitationPeaks) {
            dataOutputStream.writeDouble(quantitationPeak.getConcentration());
            QuantDatabaseWriter.writeString(dataOutputStream, quantitationPeak.getConcentrationUnit());
            IPeakMSD peakMSD = quantitationPeak.getReferencePeakMSD();
            QuantDatabaseWriter.writePeak(dataOutputStream, peakMSD);
        }
    }

    private static void writeConcentrationResponseEntries(DataOutputStream dataOutputStream, IConcentrationResponseEntriesMSD concentrationResponseEntriesMSD) throws Exception {
        dataOutputStream.writeInt(concentrationResponseEntriesMSD.size());
        for (IConcentrationResponseEntryMSD concentrationResponseEntryMSD : concentrationResponseEntriesMSD.getList()) {
            dataOutputStream.writeDouble(concentrationResponseEntryMSD.getConcentration());
            dataOutputStream.writeDouble(concentrationResponseEntryMSD.getIon());
            dataOutputStream.writeDouble(concentrationResponseEntryMSD.getResponse());
        }
    }

    private static void writeQuantitationSignals(DataOutputStream dataOutputStream, IQuantitationSignalsMSD quantitationSignalsMSD) throws Exception {
        dataOutputStream.writeInt(quantitationSignalsMSD.size());
        for (IQuantitationSignalMSD quantitationSignalMSD : quantitationSignalsMSD.getList()) {
            dataOutputStream.writeDouble(quantitationSignalMSD.getIon());
            dataOutputStream.writeFloat(quantitationSignalMSD.getRelativeResponse());
            dataOutputStream.writeDouble(quantitationSignalMSD.getUncertainty());
            dataOutputStream.writeBoolean(quantitationSignalMSD.isUse());
        }
    }

    private static void writeRetentionIndexWindow(DataOutputStream dataOutputStream, IRetentionIndexWindow retentionIndexWindow) throws Exception {
        dataOutputStream.writeFloat(retentionIndexWindow.getAllowedNegativeDeviation());
        dataOutputStream.writeFloat(retentionIndexWindow.getAllowedPositiveDeviation());
        dataOutputStream.writeFloat(retentionIndexWindow.getRetentionIndex());
    }

    private static void writeRetentionTimeWindow(DataOutputStream dataOutputStream, IRetentionTimeWindow retentionTimeWindow) throws Exception {
        dataOutputStream.writeFloat(retentionTimeWindow.getAllowedNegativeDeviation());
        dataOutputStream.writeFloat(retentionTimeWindow.getAllowedPositiveDeviation());
        dataOutputStream.writeInt(retentionTimeWindow.getRetentionTime());
    }

    private static void writePeak(DataOutputStream dataOutputStream, IPeakMSD peak) throws IOException {
        IPeakModelMSD peakModel = peak.getPeakModel();
        QuantDatabaseWriter.writeString(dataOutputStream, peak.getDetectorDescription());
        QuantDatabaseWriter.writeString(dataOutputStream, peak.getQuantifierDescription());
        dataOutputStream.writeBoolean(peak.isActiveForAnalysis());
        QuantDatabaseWriter.writeString(dataOutputStream, peak.getIntegratorDescription());
        QuantDatabaseWriter.writeString(dataOutputStream, peak.getModelDescription());
        QuantDatabaseWriter.writeString(dataOutputStream, peak.getPeakType().toString());
        dataOutputStream.writeInt(peak.getSuggestedNumberOfComponents());
        dataOutputStream.writeFloat(peakModel.getBackgroundAbundance(peakModel.getStartRetentionTime()));
        dataOutputStream.writeFloat(peakModel.getBackgroundAbundance(peakModel.getStopRetentionTime()));
        IPeakMassSpectrum massSpectrum = peakModel.getPeakMassSpectrum();
        QuantDatabaseWriter.writeMassSpectrum(dataOutputStream, (IRegularMassSpectrum)massSpectrum);
        List retentionTimes = peakModel.getRetentionTimes();
        dataOutputStream.writeInt(retentionTimes.size());
        Iterator iterator = retentionTimes.iterator();
        while (iterator.hasNext()) {
            int retentionTime = (Integer)iterator.next();
            dataOutputStream.writeInt(retentionTime);
            dataOutputStream.writeFloat(peakModel.getPeakAbundance(retentionTime));
        }
        List integrationEntries = peak.getIntegrationEntries();
        QuantDatabaseWriter.writeIntegrationEntries(dataOutputStream, integrationEntries);
        List peakTargets = peak.getTargets();
        dataOutputStream.writeInt(peakTargets.size());
        for (IPeakTarget peakTarget : peakTargets) {
            if (!(peakTarget instanceof IIdentificationTarget)) continue;
            IPeakTarget identificationEntry = peakTarget;
            QuantDatabaseWriter.writeIdentificationEntry(dataOutputStream, (IIdentificationTarget)identificationEntry);
        }
        List quantitationEntries = peak.getQuantitationEntries();
        dataOutputStream.writeInt(quantitationEntries.size());
        for (IQuantitationEntry quantitationEntry : quantitationEntries) {
            QuantDatabaseWriter.writeString(dataOutputStream, quantitationEntry.getName());
            QuantDatabaseWriter.writeString(dataOutputStream, quantitationEntry.getChemicalClass());
            dataOutputStream.writeDouble(quantitationEntry.getConcentration());
            QuantDatabaseWriter.writeString(dataOutputStream, quantitationEntry.getConcentrationUnit());
            dataOutputStream.writeDouble(quantitationEntry.getArea());
            QuantDatabaseWriter.writeString(dataOutputStream, quantitationEntry.getCalibrationMethod());
            dataOutputStream.writeBoolean(quantitationEntry.getUsedCrossZero());
            QuantDatabaseWriter.writeString(dataOutputStream, quantitationEntry.getDescription());
            if (quantitationEntry instanceof IQuantitationEntryMSD) {
                dataOutputStream.writeBoolean(true);
                IQuantitationEntryMSD quantitationEntryMSD = (IQuantitationEntryMSD)quantitationEntry;
                dataOutputStream.writeDouble(quantitationEntryMSD.getIon());
                continue;
            }
            dataOutputStream.writeBoolean(false);
        }
        IScanMSD optimizedMassSpectrum = massSpectrum.getOptimizedMassSpectrum();
        if (optimizedMassSpectrum == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            QuantDatabaseWriter.writeNormalMassSpectrum(dataOutputStream, optimizedMassSpectrum);
        }
    }

    private static void writeMassSpectrum(DataOutputStream dataOutputStream, IRegularMassSpectrum massSpectrum) throws IOException {
        dataOutputStream.writeShort(massSpectrum.getMassSpectrometer());
        dataOutputStream.writeShort(massSpectrum.getMassSpectrumType());
        dataOutputStream.writeDouble(massSpectrum.getPrecursorIon());
        QuantDatabaseWriter.writeNormalMassSpectrum(dataOutputStream, (IScanMSD)massSpectrum);
    }

    private static void writeNormalMassSpectrum(DataOutputStream dataOutputStream, IScanMSD massSpectrum) throws IOException {
        dataOutputStream.writeInt(massSpectrum.getRetentionTime());
        dataOutputStream.writeInt(massSpectrum.getRetentionTimeColumn1());
        dataOutputStream.writeInt(massSpectrum.getRetentionTimeColumn2());
        dataOutputStream.writeFloat(massSpectrum.getRetentionIndex());
        dataOutputStream.writeBoolean(massSpectrum.hasAdditionalRetentionIndices());
        if (massSpectrum.hasAdditionalRetentionIndices()) {
            Map retentionIndicesTyped = massSpectrum.getRetentionIndicesTyped();
            dataOutputStream.writeInt(retentionIndicesTyped.size());
            for (Map.Entry retentionIndexTyped : retentionIndicesTyped.entrySet()) {
                QuantDatabaseWriter.writeString(dataOutputStream, ((RetentionIndexType)retentionIndexTyped.getKey()).toString());
                dataOutputStream.writeFloat(((Float)retentionIndexTyped.getValue()).floatValue());
            }
        }
        dataOutputStream.writeInt(massSpectrum.getTimeSegmentId());
        dataOutputStream.writeInt(massSpectrum.getCycleNumber());
        List ions = massSpectrum.getIons();
        QuantDatabaseWriter.writeMassSpectrumIons(dataOutputStream, ions);
        List massSpectrumTargets = massSpectrum.getTargets();
        dataOutputStream.writeInt(massSpectrumTargets.size());
        for (IMassSpectrumTarget massSpectrumTarget : massSpectrumTargets) {
            if (!(massSpectrumTarget instanceof IIdentificationTarget)) continue;
            IMassSpectrumTarget identificationEntry = massSpectrumTarget;
            QuantDatabaseWriter.writeIdentificationEntry(dataOutputStream, (IIdentificationTarget)identificationEntry);
        }
    }

    private static void writeMassSpectrumIons(DataOutputStream dataOutputStream, List<IIon> ions) throws IOException {
        dataOutputStream.writeInt(ions.size());
        for (IIon ion : ions) {
            dataOutputStream.writeDouble(ion.getIon());
            dataOutputStream.writeFloat(ion.getAbundance());
            IIonTransition ionTransition = ion.getIonTransition();
            if (ionTransition == null) {
                dataOutputStream.writeInt(0);
                continue;
            }
            dataOutputStream.writeInt(1);
            QuantDatabaseWriter.writeString(dataOutputStream, ionTransition.getCompoundName());
            dataOutputStream.writeDouble(ionTransition.getQ1StartIon());
            dataOutputStream.writeDouble(ionTransition.getQ1StopIon());
            dataOutputStream.writeDouble(ionTransition.getQ3StartIon());
            dataOutputStream.writeDouble(ionTransition.getQ3StopIon());
            dataOutputStream.writeDouble(ionTransition.getCollisionEnergy());
            dataOutputStream.writeDouble(ionTransition.getQ1Resolution());
            dataOutputStream.writeDouble(ionTransition.getQ3Resolution());
            dataOutputStream.writeInt(ionTransition.getTransitionGroup());
            dataOutputStream.writeInt(ionTransition.getDwell());
        }
    }

    private static void writeIntegrationEntries(DataOutputStream dataOutputStream, List<? extends IIntegrationEntry> integrationEntries) throws IOException {
        dataOutputStream.writeInt(integrationEntries.size());
        for (IIntegrationEntry iIntegrationEntry : integrationEntries) {
            if (!(iIntegrationEntry instanceof IIntegrationEntryMSD)) continue;
            IIntegrationEntryMSD integrationEntryMSD = (IIntegrationEntryMSD)iIntegrationEntry;
            dataOutputStream.writeDouble(integrationEntryMSD.getIon());
            dataOutputStream.writeDouble(integrationEntryMSD.getIntegratedArea());
        }
    }

    private static void writeIdentificationEntry(DataOutputStream dataOutputStream, IIdentificationTarget identificationEntry) throws IOException {
        ILibraryInformation libraryInformation = identificationEntry.getLibraryInformation();
        IComparisonResult comparisonResult = identificationEntry.getComparisonResult();
        QuantDatabaseWriter.writeString(dataOutputStream, identificationEntry.getIdentifier());
        dataOutputStream.writeBoolean(identificationEntry.isManuallyVerified());
        QuantDatabaseWriter.writeString(dataOutputStream, libraryInformation.getCasNumber());
        QuantDatabaseWriter.writeString(dataOutputStream, libraryInformation.getComments());
        QuantDatabaseWriter.writeString(dataOutputStream, libraryInformation.getReferenceIdentifier());
        QuantDatabaseWriter.writeString(dataOutputStream, libraryInformation.getMiscellaneous());
        QuantDatabaseWriter.writeString(dataOutputStream, libraryInformation.getDatabase());
        QuantDatabaseWriter.writeString(dataOutputStream, libraryInformation.getContributor());
        QuantDatabaseWriter.writeString(dataOutputStream, libraryInformation.getName());
        Set synonyms = libraryInformation.getSynonyms();
        int numberOfSynonyms = synonyms.size();
        dataOutputStream.writeInt(numberOfSynonyms);
        for (String synonym : synonyms) {
            QuantDatabaseWriter.writeString(dataOutputStream, synonym);
        }
        QuantDatabaseWriter.writeString(dataOutputStream, libraryInformation.getFormula());
        QuantDatabaseWriter.writeString(dataOutputStream, libraryInformation.getSmiles());
        QuantDatabaseWriter.writeString(dataOutputStream, libraryInformation.getInChI());
        dataOutputStream.writeDouble(libraryInformation.getMolWeight());
        dataOutputStream.writeFloat(comparisonResult.getMatchFactor());
        dataOutputStream.writeFloat(comparisonResult.getMatchFactorDirect());
        dataOutputStream.writeFloat(comparisonResult.getReverseMatchFactor());
        dataOutputStream.writeFloat(comparisonResult.getReverseMatchFactorDirect());
        dataOutputStream.writeFloat(comparisonResult.getProbability());
        dataOutputStream.writeBoolean(comparisonResult.isMatch());
    }

    private static void writeString(DataOutputStream dataOutputStream, String value) throws IOException {
        dataOutputStream.writeInt(value.length());
        dataOutputStream.writeChars(value);
    }
}

