/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.support;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.model.exceptions.AnalysisSupportException;
import org.eclipse.chemclipse.model.support.AnalysisSegment;
import org.eclipse.chemclipse.model.support.IAnalysisSegment;
import org.eclipse.chemclipse.model.support.IAnalysisSupport;
import org.eclipse.chemclipse.model.support.IScanRange;

public class AnalysisSupport
implements IAnalysisSupport {
    private List<IAnalysisSegment> analysisSegments;

    public AnalysisSupport(int numberOfScans, int segmentWidth) throws AnalysisSupportException {
        if (segmentWidth < 3 || numberOfScans < segmentWidth) {
            throw new AnalysisSupportException("The segmentWidth must be >= 3 and the number of scans must be >= segmentWidth.");
        }
        this.initializeAnalysisSegments(numberOfScans, 1, segmentWidth);
    }

    public AnalysisSupport(IScanRange scanRange, int segmentWidth) throws AnalysisSupportException {
        if (scanRange == null) {
            throw new AnalysisSupportException("The scan range must not be null.");
        }
        if (segmentWidth < 3 || scanRange.getWidth() < segmentWidth) {
            throw new AnalysisSupportException("The segmentWidth must be >= 3 and the number of scans must be >= segmentWidth.");
        }
        this.initializeAnalysisSegments(scanRange.getWidth(), scanRange.getStartScan(), segmentWidth);
    }

    @Override
    public int getNumberOfAnalysisSegments() {
        return this.analysisSegments.size();
    }

    @Override
    public List<IAnalysisSegment> getAnalysisSegments() {
        return this.analysisSegments;
    }

    private void initializeAnalysisSegments(int numberOfScans, int startScan, int segmentWidth) {
        AnalysisSegment segment;
        assert (numberOfScans > 0) : "The number of scans must be > 0";
        assert (segmentWidth > 0) : "The segment width must be > 0";
        boolean addLastSegment = false;
        int lastSegmentWidth = numberOfScans % segmentWidth;
        if (lastSegmentWidth > 0) {
            addLastSegment = true;
        }
        int segmentParts = (numberOfScans -= lastSegmentWidth) / segmentWidth;
        this.analysisSegments = new ArrayList<IAnalysisSegment>();
        int i = 1;
        while (i <= segmentParts) {
            segment = new AnalysisSegment(startScan, segmentWidth);
            this.analysisSegments.add(segment);
            startScan += segmentWidth;
            ++i;
        }
        if (addLastSegment) {
            segment = new AnalysisSegment(startScan, lastSegmentWidth);
            this.analysisSegments.add(segment);
        }
    }
}

