/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.thirdpartylibraries.swtchart.ext;

import org.eclipse.chemclipse.thirdpartylibraries.swtchart.ext.IResetUpdateListener;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.swtchart.IAxis;
import org.swtchart.Range;
import org.swtchart.ext.InteractiveChart;
import org.swtchart.ext.internal.properties.AxisPage;
import org.swtchart.ext.internal.properties.AxisTickPage;
import org.swtchart.ext.internal.properties.ChartPage;
import org.swtchart.ext.internal.properties.GridPage;
import org.swtchart.ext.internal.properties.LegendPage;
import org.swtchart.ext.internal.properties.PropertiesResources;
import org.swtchart.ext.internal.properties.SeriesLabelPage;
import org.swtchart.ext.internal.properties.SeriesPage;

public class InteractiveChartExtended
extends InteractiveChart
implements PaintListener,
KeyListener,
MouseListener,
MouseMoveListener,
MouseWheelListener,
IResetUpdateListener {
    private long clickedTimeInMilliseconds;
    private int xStart;
    public static final String ADJUST_AXIS_RANGE_GROUP = "Unzoom";
    public static final String ADJUST_AXIS_RANGE = "Reset 1:1";
    public static final String ADJUST_X_AXIS_RANGE = "Unzoom X-Axis";
    public static final String ADJUST_Y_AXIS_RANGE = "Unzoom Y-Axis";
    public static final String ADJUST_PREVIOUS_AXIS_RANGE = "Previous Selection";
    public static final String LEGEND = "Legend";
    public static final String LEGEND_SHOW = "Show Legend";
    public static final String LEGEND_HIDE = "Hide Legend";
    public static final String GRAPH = "Graph";
    public static final String GRAPH_SETTINGS = "Settings";
    private static final String X_AXIS = "Axis(x)";
    private static final String GRID = "Grid";
    private static final String TICK = "Tick";
    private static final String Y_AXIS = "Axis(y)";
    private static final String SERIES = "Series";
    private static final String LABEL = "Label";
    private PropertiesResources resources = new PropertiesResources();

    public InteractiveChartExtended(Composite parent, int style) {
        super(parent, style);
        this.init();
    }

    @Override
    public void handleEvent(Event event) {
        switch (event.type) {
            case 13: {
                this.widgetSelected(event);
                break;
            }
            case 11: {
                this.updateLayout();
                this.redraw();
                break;
            }
        }
    }

    @Override
    public void paintControl(PaintEvent e) {
        this.selection.draw(e.gc);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if (e.button == 1) {
            this.xStart = e.x;
            this.selection.setStartPoint(e.x, e.y);
            this.clickedTimeInMilliseconds = System.currentTimeMillis();
        }
    }

    public void mouseUp(MouseEvent e) {
        if (e.button == 1 && System.currentTimeMillis() - this.clickedTimeInMilliseconds > 100L) {
            Composite plotArea = this.getPlotArea();
            int minSelectedWidth = plotArea.getBounds().width / 30;
            int deltaWidth = Math.abs(this.xStart - e.x);
            if (deltaWidth >= minSelectedWidth) {
                IAxis[] iAxisArray = this.getAxisSet().getAxes();
                int n = iAxisArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAxis axis = iAxisArray[n2];
                    Point range = null;
                    range = this.getOrientation() == 256 && axis.getDirection() == IAxis.Direction.X || this.getOrientation() == 512 && axis.getDirection() == IAxis.Direction.Y ? this.selection.getHorizontalRange() : this.selection.getVerticalRange();
                    if (range != null && range.x != range.y) {
                        this.setRange(range, axis);
                    }
                    ++n2;
                }
            }
        }
        this.selection.dispose();
        this.redraw();
    }

    public void mouseMove(MouseEvent e) {
        if (!this.selection.isDisposed()) {
            this.selection.setEndPoint(e.x, e.y);
            this.redraw();
        }
    }

    public void mouseScrolled(MouseEvent e) {
        double coordinate;
        IAxis axis;
        IAxis[] iAxisArray = this.getAxes(256);
        int n = iAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            axis = iAxisArray[n2];
            coordinate = axis.getDataCoordinate(e.x);
            if (e.count > 0) {
                axis.zoomIn(coordinate);
            } else {
                axis.zoomOut(coordinate);
            }
            ++n2;
        }
        iAxisArray = this.getAxes(512);
        n = iAxisArray.length;
        n2 = 0;
        while (n2 < n) {
            axis = iAxisArray[n2];
            coordinate = axis.getDataCoordinate(e.y);
            if (e.count > 0) {
                axis.zoomIn(coordinate);
            } else {
                axis.zoomOut(coordinate);
            }
            ++n2;
        }
        this.redraw();
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == 0x1000002) {
            if (e.stateMask == 262144) {
                this.getAxisSet().zoomOut();
            } else {
                IAxis[] iAxisArray = this.getAxes(512);
                int n = iAxisArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAxis axis = iAxisArray[n2];
                    axis.scrollDown();
                    ++n2;
                }
            }
            this.redraw();
        } else if (e.keyCode == 0x1000001) {
            if (e.stateMask == 262144) {
                this.getAxisSet().zoomIn();
            } else {
                IAxis[] iAxisArray = this.getAxes(512);
                int n = iAxisArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IAxis axis = iAxisArray[n3];
                    axis.scrollUp();
                    ++n3;
                }
            }
            this.redraw();
        } else if (e.keyCode == 0x1000003) {
            IAxis[] iAxisArray = this.getAxes(256);
            int n = iAxisArray.length;
            int n4 = 0;
            while (n4 < n) {
                IAxis axis = iAxisArray[n4];
                axis.scrollDown();
                ++n4;
            }
            this.redraw();
        } else if (e.keyCode == 0x1000004) {
            IAxis[] iAxisArray = this.getAxes(256);
            int n = iAxisArray.length;
            int n5 = 0;
            while (n5 < n) {
                IAxis axis = iAxisArray[n5];
                axis.scrollUp();
                ++n5;
            }
            this.redraw();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void widgetSelected(Event e) {
        if (!(e.widget instanceof MenuItem)) {
            return;
        }
        MenuItem menuItem = (MenuItem)e.widget;
        if (menuItem.getText().equals(ADJUST_AXIS_RANGE)) {
            this.adjustRange();
        } else if (menuItem.getText().equals(ADJUST_X_AXIS_RANGE)) {
            this.adjustXRange();
        } else if (menuItem.getText().equals(ADJUST_Y_AXIS_RANGE)) {
            this.adjustYRange();
        } else if (menuItem.getText().equals(ADJUST_PREVIOUS_AXIS_RANGE)) {
            this.adjustPreviousRange();
        } else if (menuItem.getText().equals(LEGEND_SHOW)) {
            this.getLegend().setVisible(true);
        } else if (menuItem.getText().equals(LEGEND_HIDE)) {
            this.getLegend().setVisible(false);
        } else if (menuItem.getText().equals(GRAPH_SETTINGS)) {
            this.openSettingsDialog();
        }
        this.redraw();
    }

    @Override
    public void adjustRange() {
        this.getAxisSet().adjustRange();
    }

    @Override
    public void adjustXRange() {
        IAxis[] iAxisArray = this.getAxisSet().getXAxes();
        int n = iAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis axis = iAxisArray[n2];
            axis.adjustRange();
            ++n2;
        }
    }

    @Override
    public void adjustYRange() {
        IAxis[] iAxisArray = this.getAxisSet().getYAxes();
        int n = iAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis axis = iAxisArray[n2];
            axis.adjustRange();
            ++n2;
        }
    }

    @Override
    public void adjustPreviousRange() {
        this.getAxisSet().adjustRange();
    }

    private void openSettingsDialog() {
        PreferenceManager manager = new PreferenceManager();
        PreferenceNode chartNode = new PreferenceNode(GRAPH);
        chartNode.setPage((IPreferencePage)new ChartPage(this, this.resources, GRAPH));
        manager.addToRoot((IPreferenceNode)chartNode);
        PreferenceNode legendNode = new PreferenceNode(LEGEND);
        legendNode.setPage((IPreferencePage)new LegendPage(this, this.resources, LEGEND));
        manager.addTo(GRAPH, (IPreferenceNode)legendNode);
        PreferenceNode xAxisNode = new PreferenceNode(X_AXIS);
        xAxisNode.setPage((IPreferencePage)new AxisPage((InteractiveChart)this, this.resources, IAxis.Direction.X, X_AXIS));
        manager.addTo(GRAPH, (IPreferenceNode)xAxisNode);
        PreferenceNode xGridNode = new PreferenceNode(GRID);
        xGridNode.setPage((IPreferencePage)new GridPage((InteractiveChart)this, this.resources, IAxis.Direction.X, GRID));
        manager.addTo("Graph.Axis(x)", (IPreferenceNode)xGridNode);
        PreferenceNode xTickNode = new PreferenceNode(TICK);
        xTickNode.setPage((IPreferencePage)new AxisTickPage((InteractiveChart)this, this.resources, IAxis.Direction.X, TICK));
        manager.addTo("Graph.Axis(x)", (IPreferenceNode)xTickNode);
        PreferenceNode yAxisNode = new PreferenceNode(Y_AXIS);
        yAxisNode.setPage((IPreferencePage)new AxisPage((InteractiveChart)this, this.resources, IAxis.Direction.Y, Y_AXIS));
        manager.addTo(GRAPH, (IPreferenceNode)yAxisNode);
        PreferenceNode yGridNode = new PreferenceNode(GRID);
        yGridNode.setPage((IPreferencePage)new GridPage((InteractiveChart)this, this.resources, IAxis.Direction.Y, GRID));
        manager.addTo("Graph.Axis(y)", (IPreferenceNode)yGridNode);
        PreferenceNode yTickNode = new PreferenceNode(TICK);
        yTickNode.setPage((IPreferencePage)new AxisTickPage((InteractiveChart)this, this.resources, IAxis.Direction.Y, TICK));
        manager.addTo("Graph.Axis(y)", (IPreferenceNode)yTickNode);
        PreferenceNode plotNode = new PreferenceNode(SERIES);
        plotNode.setPage((IPreferencePage)new SeriesPage(this, this.resources, SERIES));
        manager.addTo(GRAPH, (IPreferenceNode)plotNode);
        PreferenceNode labelNode = new PreferenceNode(LABEL);
        labelNode.setPage((IPreferencePage)new SeriesLabelPage(this, this.resources, LABEL));
        manager.addTo("Graph.Series", (IPreferenceNode)labelNode);
        PreferenceDialog preferenceDialog = new PreferenceDialog(this.getShell(), manager);
        preferenceDialog.create();
        preferenceDialog.getShell().setText(GRAPH_SETTINGS);
        preferenceDialog.getTreeViewer().expandAll();
        preferenceDialog.open();
    }

    private IAxis[] getAxes(int orientation) {
        IAxis[] axes = this.getOrientation() == orientation ? this.getAxisSet().getXAxes() : this.getAxisSet().getYAxes();
        return axes;
    }

    private void setRange(Point range, IAxis axis) {
        if (range == null) {
            return;
        }
        double min = axis.getDataCoordinate(range.x);
        double max = axis.getDataCoordinate(range.y);
        axis.setRange(new Range(min, max));
    }

    private void init() {
        Composite plotArea = this.getPlotArea();
        plotArea.addPaintListener((PaintListener)this);
        plotArea.addKeyListener((KeyListener)this);
        plotArea.addMouseListener((MouseListener)this);
        plotArea.addMouseMoveListener((MouseMoveListener)this);
        plotArea.addMouseWheelListener((MouseWheelListener)this);
        this.createMenuItems();
    }

    private void createMenuItems() {
        Menu menu = new Menu((Control)this.getPlotArea());
        this.getPlotArea().setMenu(menu);
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText(ADJUST_AXIS_RANGE_GROUP);
        Menu adjustAxisRangeMenu = new Menu(menuItem);
        menuItem.setMenu(adjustAxisRangeMenu);
        menuItem = new MenuItem(adjustAxisRangeMenu, 8);
        menuItem.setText(ADJUST_AXIS_RANGE);
        menuItem.addListener(13, (Listener)this);
        menuItem = new MenuItem(adjustAxisRangeMenu, 8);
        menuItem.setText(ADJUST_X_AXIS_RANGE);
        menuItem.addListener(13, (Listener)this);
        menuItem = new MenuItem(adjustAxisRangeMenu, 8);
        menuItem.setText(ADJUST_Y_AXIS_RANGE);
        menuItem.addListener(13, (Listener)this);
        menuItem = new MenuItem(adjustAxisRangeMenu, 8);
        menuItem.setText(ADJUST_PREVIOUS_AXIS_RANGE);
        menuItem.addListener(13, (Listener)this);
        menuItem = new MenuItem(menu, 2);
        menuItem = new MenuItem(menu, 64);
        menuItem.setText(LEGEND);
        Menu legendMenu = new Menu(menuItem);
        menuItem.setMenu(legendMenu);
        menuItem = new MenuItem(legendMenu, 8);
        menuItem.setText(LEGEND_SHOW);
        menuItem.addListener(13, (Listener)this);
        menuItem = new MenuItem(legendMenu, 8);
        menuItem.setText(LEGEND_HIDE);
        menuItem.addListener(13, (Listener)this);
        menuItem = new MenuItem(menu, 2);
        menuItem = new MenuItem(menu, 64);
        menuItem.setText(GRAPH);
        Menu graphMenu = new Menu(menuItem);
        menuItem.setMenu(graphMenu);
        menuItem = new MenuItem(graphMenu, 8);
        menuItem.setText(GRAPH_SETTINGS);
        menuItem.addListener(13, (Listener)this);
    }
}

