/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.filter.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.massspectrum.AbstractMassSpectrumFilter;
import org.eclipse.chemclipse.chromatogram.msd.filter.processing.IMassSpectrumFilterProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.filter.processing.MassSpectrumFilterProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.filter.result.IMassSpectrumFilterResult;
import org.eclipse.chemclipse.chromatogram.msd.filter.result.MassSpectrumFilterResult;
import org.eclipse.chemclipse.chromatogram.msd.filter.settings.IMassSpectrumFilterSettings;
import org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.calculator.FilterSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.settings.ISnipMassSpectrumFilterSettings;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.IProgressMonitor;

public class MassSpectrumFilter
extends AbstractMassSpectrumFilter {
    private static final String DESCRIPTION = "SNIP Filter Mass Spectra";

    public IMassSpectrumFilterProcessingInfo applyFilter(List<IScanMSD> massSpectra, IMassSpectrumFilterSettings massSpectrumFilterSettings, IProgressMonitor monitor) {
        MassSpectrumFilterProcessingInfo processingInfo = new MassSpectrumFilterProcessingInfo();
        processingInfo.addMessages(this.validate(massSpectra, massSpectrumFilterSettings));
        if (processingInfo.hasErrorMessages()) {
            return processingInfo;
        }
        if (massSpectrumFilterSettings instanceof ISnipMassSpectrumFilterSettings) {
            ISnipMassSpectrumFilterSettings snipMassSpectrumFilterSettings = (ISnipMassSpectrumFilterSettings)massSpectrumFilterSettings;
            FilterSupplier filterSupplier = new FilterSupplier();
            int iterations = snipMassSpectrumFilterSettings.getIterations();
            int transitions = snipMassSpectrumFilterSettings.getTransitions();
            double magnificationFactor = snipMassSpectrumFilterSettings.getMagnificationFactor();
            filterSupplier.applySnipFilter(massSpectra, iterations, transitions, magnificationFactor, monitor);
            processingInfo.addMessage((IProcessingMessage)new ProcessingMessage(MessageType.INFO, DESCRIPTION, "The mass spectrum has been optimized successfully."));
        } else {
            processingInfo.addErrorMessage(DESCRIPTION, "The filter settings instance is not a type of: " + ISnipMassSpectrumFilterSettings.class);
        }
        MassSpectrumFilterResult massSpectrumFilterResult = new MassSpectrumFilterResult(ResultStatus.OK, "The SNIP filter has been applied successfully.");
        processingInfo.setMassSpectrumFilterResult((IMassSpectrumFilterResult)massSpectrumFilterResult);
        return processingInfo;
    }

    public IMassSpectrumFilterProcessingInfo applyFilter(IScanMSD massSpectrum, IMassSpectrumFilterSettings massSpectrumFilterSettings, IProgressMonitor monitor) {
        ArrayList<IScanMSD> massSpectra = new ArrayList<IScanMSD>();
        massSpectra.add(massSpectrum);
        return this.applyFilter(massSpectra, massSpectrumFilterSettings, monitor);
    }

    public IMassSpectrumFilterProcessingInfo applyFilter(IScanMSD massSpectrum, IProgressMonitor monitor) {
        ISnipMassSpectrumFilterSettings massSpectrumFilterSettings = PreferenceSupplier.getMassSpectrumFilterSettings();
        return this.applyFilter(massSpectrum, (IMassSpectrumFilterSettings)massSpectrumFilterSettings, monitor);
    }

    public IMassSpectrumFilterProcessingInfo applyFilter(List<IScanMSD> massSpectra, IProgressMonitor monitor) {
        ISnipMassSpectrumFilterSettings massSpectrumFilterSettings = PreferenceSupplier.getMassSpectrumFilterSettings();
        return this.applyFilter(massSpectra, (IMassSpectrumFilterSettings)massSpectrumFilterSettings, monitor);
    }
}

