/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.numeric.equations;

import org.eclipse.chemclipse.numeric.equations.IEquation;

public class PolynomicalEquation9thDegree
implements IEquation {
    private static final long serialVersionUID = 6883637910982170361L;
    private double a;
    private double b;
    private double c;
    private double d;
    private double e;
    private double f;
    private double g;
    private double h;
    private double i;

    public PolynomicalEquation9thDegree(double a, double b, double c, double d, double e, double f, double g, double h, double i) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.e = e;
        this.f = f;
        this.g = g;
        this.h = h;
        this.i = i;
    }

    @Override
    public double calculateY(double x) {
        double ax = this.a * Math.pow(x, 9.0);
        double bx = this.b * Math.pow(x, 8.0);
        double cx = this.c * Math.pow(x, 7.0);
        double dx = this.d * Math.pow(x, 6.0);
        double ex = this.e * Math.pow(x, 5.0);
        double fx = this.f * Math.pow(x, 4.0);
        double gx = this.g * Math.pow(x, 3.0);
        double hx = this.h * Math.pow(x, 2.0);
        double ix = this.i;
        double result = ax + bx + cx + dx + ex + fx + gx + hx + ix;
        return result;
    }

    @Override
    public double calculateX(double y) {
        return 0.0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("f(x)=");
        builder.append(String.valueOf(this.a) + "x^9");
        builder.append(" + ");
        builder.append(String.valueOf(this.b) + "x^8");
        builder.append(" + ");
        builder.append(String.valueOf(this.c) + "x^7");
        builder.append(" + ");
        builder.append(String.valueOf(this.d) + "x^6");
        builder.append(" + ");
        builder.append(String.valueOf(this.e) + "x^5");
        builder.append(" + ");
        builder.append(String.valueOf(this.f) + "x^4");
        builder.append(" + ");
        builder.append(String.valueOf(this.g) + "x^3");
        builder.append(" + ");
        builder.append(String.valueOf(this.h) + "x^2");
        builder.append(" + ");
        builder.append(this.i);
        builder.append("]");
        return builder.toString();
    }
}

