/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.swt.ui.support.IOffset;
import org.eclipse.chemclipse.swt.ui.support.Offset;
import org.eclipse.chemclipse.ux.extension.msd.ui.editors.ChromatogramEditorMSD;
import org.eclipse.chemclipse.ux.extension.msd.ui.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.ux.extension.msd.ui.views.AbstractChromatogramSelectionMSDView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public abstract class AbstractChromatogramOverlayView
extends AbstractChromatogramSelectionMSDView {
    private EPartService partService;

    public AbstractChromatogramOverlayView(MPart part, EPartService partService, IEventBroker eventBroker) {
        super(part, partService, eventBroker);
        this.partService = partService;
    }

    public List<IChromatogramSelection> getChromatogramSelections(IChromatogramSelection masterChromatogramSelection) {
        ArrayList<IChromatogramSelection> chromatogramSelections = new ArrayList<IChromatogramSelection>();
        if (masterChromatogramSelection.isOverlaySelected()) {
            chromatogramSelections.add(masterChromatogramSelection);
        }
        Collection parts = this.partService.getParts();
        for (MPart part : parts) {
            ChromatogramEditorMSD editor;
            IChromatogramSelectionMSD selection;
            Object object;
            if (!part.getElementId().equals("org.eclipse.chemclipse.ux.extension.msd.ui.part.chromatogramEditor") || (object = part.getObject()) == null || !(object instanceof ChromatogramEditorMSD) || (selection = (editor = (ChromatogramEditorMSD)object).getChromatogramSelection()) == masterChromatogramSelection || !selection.isOverlaySelected()) continue;
            chromatogramSelections.add((IChromatogramSelection)selection);
        }
        return chromatogramSelections;
    }

    public IOffset getOffset() {
        int xOffset = PreferenceSupplier.getOverlayXOffset();
        int yOffset = PreferenceSupplier.getOverlayYOffset();
        Offset offset = new Offset((double)xOffset, (double)yOffset);
        return offset;
    }
}

