/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.ui.provider;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.swt.graphics.Image;

public class TargetsLabelProvider
extends AbstractChemClipseLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            if (element instanceof IIdentificationTarget) {
                IIdentificationTarget identificationTarget = (IIdentificationTarget)element;
                if (identificationTarget.isManuallyVerified()) {
                    return ApplicationImageFactory.getInstance().getImage("selected.gif", "16x16");
                }
                return ApplicationImageFactory.getInstance().getImage("deselected.gif", "16x16");
            }
        } else if (columnIndex == 1) {
            if (element instanceof IIdentificationTarget) {
                IIdentificationTarget identificationTarget = (IIdentificationTarget)element;
                float rating = identificationTarget.getComparisonResult().getRating();
                if (rating >= 90.0f) {
                    return ApplicationImageFactory.getInstance().getImage("arrow_up.gif", "16x16");
                }
                if (rating >= 70.0f) {
                    return ApplicationImageFactory.getInstance().getImage("arrow_equal.gif", "16x16");
                }
                return ApplicationImageFactory.getInstance().getImage("arrow_down.gif", "16x16");
            }
        } else if (columnIndex == 2) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DecimalFormat decimalFormat = this.getDecimalFormat();
        String text = "";
        if (element instanceof IIdentificationTarget) {
            IIdentificationTarget identificationEntry = (IIdentificationTarget)element;
            ILibraryInformation libraryInformation = identificationEntry.getLibraryInformation();
            IComparisonResult comparisonResult = identificationEntry.getComparisonResult();
            switch (columnIndex) {
                case 0: {
                    text = "";
                    break;
                }
                case 1: {
                    text = "";
                    break;
                }
                case 2: {
                    text = libraryInformation.getName();
                    break;
                }
                case 3: {
                    text = libraryInformation.getCasNumber();
                    break;
                }
                case 4: {
                    text = decimalFormat.format(comparisonResult.getMatchFactor());
                    break;
                }
                case 5: {
                    text = decimalFormat.format(comparisonResult.getReverseMatchFactor());
                    break;
                }
                case 6: {
                    text = decimalFormat.format(comparisonResult.getMatchFactorDirect());
                    break;
                }
                case 7: {
                    text = decimalFormat.format(comparisonResult.getReverseMatchFactorDirect());
                    break;
                }
                case 8: {
                    text = decimalFormat.format(comparisonResult.getProbability());
                    break;
                }
                case 9: {
                    text = libraryInformation.getFormula();
                    break;
                }
                case 10: {
                    text = libraryInformation.getSmiles();
                    break;
                }
                case 11: {
                    text = libraryInformation.getInChI();
                    break;
                }
                case 12: {
                    text = decimalFormat.format(libraryInformation.getMolWeight());
                    break;
                }
                case 13: {
                    text = comparisonResult.getAdvise();
                    break;
                }
                case 14: {
                    text = identificationEntry.getIdentifier();
                    break;
                }
                case 15: {
                    text = libraryInformation.getMiscellaneous();
                    break;
                }
                case 16: {
                    text = libraryInformation.getComments();
                    break;
                }
                case 17: {
                    text = libraryInformation.getDatabase();
                    break;
                }
                case 18: {
                    text = libraryInformation.getContributor();
                    break;
                }
                case 19: {
                    text = libraryInformation.getReferenceIdentifier();
                    break;
                }
                default: {
                    text = "n.v.";
                }
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        Image image = ApplicationImageFactory.getInstance().getImage("targets.gif", "16x16");
        return image;
    }
}

