/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.common;

import java.io.IOException;
import org.apache.sshd.agent.SshAgentServer;
import org.apache.sshd.common.SshException;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentForwardSupport {
    private static final Logger log = LoggerFactory.getLogger(AgentForwardSupport.class);
    private final ServerSession session;
    private String agentId;
    private SshAgentServer agentServer;

    public AgentForwardSupport(ServerSession session) {
        this.session = session;
    }

    public String initialize() throws IOException {
        try {
            if (this.agentId == null) {
                this.agentServer = this.session.getFactoryManager().getAgentFactory().createServer(this.session);
                this.agentId = this.agentServer.getId();
            }
            return this.agentId;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SshException(e);
        }
    }

    public synchronized void close() {
        if (this.agentId != null) {
            this.agentId = null;
            this.agentServer.close();
            this.agentServer = null;
        }
    }
}

