/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.internal.identifier;

import java.io.FileNotFoundException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RecursiveTask;
import java.util.function.Function;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.IMassSpectrumComparator;
import org.eclipse.chemclipse.chromatogram.msd.identifier.settings.IIdentifierSettingsMSD;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.settings.IFileIdentifierSettings;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.settings.MassSpectrumIdentifierSettings;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.settings.PeakIdentifierSettings;
import org.eclipse.chemclipse.chromatogram.msd.identifier.support.DatabasesCache;
import org.eclipse.chemclipse.chromatogram.msd.identifier.support.PenaltyCalculationSupport;
import org.eclipse.chemclipse.chromatogram.msd.identifier.support.TargetBuilder;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.IPeakIdentificationResults;
import org.eclipse.chemclipse.model.identifier.MatchConstraints;
import org.eclipse.chemclipse.model.identifier.PeakIdentificationResults;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.implementation.MassSpectra;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.support.settings.UserManagement;
import org.eclipse.chemclipse.support.util.FileListUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class FileIdentifier {
    public static final String IDENTIFIER = "File Identifier";
    private static final Comparator<IComparisonResult> RESULT_COMPARATOR = Collections.reverseOrder(IComparisonResult.MATCH_FACTOR_COMPARATOR);
    private static final TargetBuilder TARGETBUILDER = new TargetBuilder();
    private final DatabasesCache databasesCache = new DatabasesCache(PreferenceSupplier.getMassSpectraFiles());

    public IMassSpectra runIdentification(List<IScanMSD> massSpectraList, MassSpectrumIdentifierSettings fileIdentifierSettings, IProgressMonitor monitor) throws FileNotFoundException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Running mass spectra identification", (int)100);
        MassSpectra massSpectra = new MassSpectra();
        massSpectra.addMassSpectra(massSpectraList);
        String identifier = IDENTIFIER;
        String alternateIdentifierId = fileIdentifierSettings.getAlternateIdentifierId();
        if (alternateIdentifierId != null && !alternateIdentifierId.isEmpty()) {
            identifier = alternateIdentifierId;
        }
        FileListUtil fileListUtil = new FileListUtil();
        Map databases = this.databasesCache.getDatabases(fileListUtil.getFiles(fileIdentifierSettings.getMassSpectraFiles()), (IProgressMonitor)subMonitor.split(10));
        subMonitor.setWorkRemaining(databases.size() * 100);
        for (Map.Entry database : databases.entrySet()) {
            FileIdentifier.compareMassSpectraAgainstDatabase(massSpectra.getList(), ((IMassSpectra)database.getValue()).getList(), fileIdentifierSettings, identifier, (String)database.getKey(), (IProgressMonitor)subMonitor.split(100, 0));
        }
        return massSpectra;
    }

    public IPeakIdentificationResults runPeakIdentification(List<? extends IPeakMSD> peaks, PeakIdentifierSettings peakIdentifierSettings, IProcessingInfo<?> processingInfo, IProgressMonitor monitor) throws FileNotFoundException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Running mass spectra identification", (int)100);
        PeakIdentificationResults identificationResults = new PeakIdentificationResults();
        String identifier = IDENTIFIER;
        String alternateIdentifierId = peakIdentifierSettings.getAlternateIdentifierId();
        if (alternateIdentifierId != null && !alternateIdentifierId.isEmpty()) {
            identifier = alternateIdentifierId;
        }
        FileListUtil fileListUtil = new FileListUtil();
        String massSpectraFiles = peakIdentifierSettings.getMassSpectraFiles();
        List files = fileListUtil.getFiles(massSpectraFiles);
        Map databases = this.databasesCache.getDatabases(files, (IProgressMonitor)subMonitor.split(10));
        subMonitor.setWorkRemaining(databases.size() * 100);
        for (Map.Entry database : databases.entrySet()) {
            FileIdentifier.comparePeaksAgainstDatabase(peaks, ((IMassSpectra)database.getValue()).getList(), peakIdentifierSettings, identifier, (String)database.getKey(), (IProgressMonitor)subMonitor.split(100, 0));
        }
        return identificationResults;
    }

    public IMassSpectra getMassSpectra(IIdentificationTarget identificationTarget, IProgressMonitor monitor) {
        MassSpectra massSpectra = new MassSpectra();
        if (this.isValid(identificationTarget)) {
            massSpectra.addMassSpectra((Collection)this.databasesCache.getDatabaseMassSpectra(identificationTarget, monitor));
        }
        return massSpectra;
    }

    public boolean isValid(IIdentificationTarget identificationTarget) {
        if (identificationTarget != null) {
            String id = identificationTarget.getIdentifier();
            return IDENTIFIER.equals(id) || "".equals(id);
        }
        return false;
    }

    public DatabasesCache getDatabasesCache() {
        return this.databasesCache;
    }

    public static int compareMassSpectraAgainstDatabase(List<? extends IScanMSD> unknownList, List<? extends IScanMSD> references, MassSpectrumIdentifierSettings fileIdentifierSettings, String identifier, String databaseName, IProgressMonitor monitor) {
        return FileIdentifier.compareAgainstDatabase(unknownList, scan -> scan, references, fileIdentifierSettings, identifier, databaseName, monitor);
    }

    public static int comparePeaksAgainstDatabase(List<? extends IPeakMSD> unknownList, List<IScanMSD> references, PeakIdentifierSettings fileIdentifierSettings, String identifier, String databaseName, IProgressMonitor monitor) {
        return FileIdentifier.compareAgainstDatabase(unknownList, peak -> peak.getPeakModel().getPeakMassSpectrum(), references, fileIdentifierSettings, identifier, databaseName, monitor);
    }

    private static <T> int compareAgainstDatabase(Collection<T> unknownList, Function<T, IScanMSD> extractor, List<? extends IScanMSD> references, IFileIdentifierSettings fileIdentifierSettings, String identifier, String databaseName, IProgressMonitor monitor) {
        int matched = 0;
        long start = System.currentTimeMillis();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)("Comparing against database " + databaseName + " with " + references.size() + " massspectra"), (int)unknownList.size());
        IMassSpectrumComparator massSpectrumComparator = fileIdentifierSettings.getMassSpectrumComparator();
        int count = 1;
        int total = unknownList.size();
        for (T item : unknownList) {
            if (subMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            subMonitor.subTask("Reference " + count + "/" + total + " (matches found: " + matched + ")");
            IScanMSD unknown = extractor.apply(item);
            Map matches = (Map)new FindMatchingSpectras(unknown, references, fileIdentifierSettings, massSpectrumComparator).invoke();
            if (matches.size() > 0) {
                ++matched;
                ArrayList resultList = new ArrayList(matches.keySet());
                Collections.sort(resultList, RESULT_COMPARATOR);
                int size = Math.min(fileIdentifierSettings.getNumberOfTargets(), matches.size());
                int i = 0;
                while (i < size) {
                    IComparisonResult comparisonResult = (IComparisonResult)resultList.get(i);
                    IIdentificationTarget massSpectrumTarget = TARGETBUILDER.getMassSpectrumTarget((IScanMSD)matches.get(comparisonResult), comparisonResult, identifier, databaseName);
                    unknown.getTargets().add(massSpectrumTarget);
                    ++i;
                }
            }
            ++count;
            subMonitor.worked(1);
        }
        if (UserManagement.isDevMode()) {
            long end = System.currentTimeMillis();
            NumberFormat integerFormat = NumberFormat.getIntegerInstance();
            NumberFormat timeFormat = NumberFormat.getNumberInstance();
            timeFormat.setMaximumFractionDigits(2);
            System.out.println("#PERF# Identifaction of " + integerFormat.format(unknownList.size()) + " unknown items against database " + databaseName + " with " + integerFormat.format(references.size()) + " massspectra took " + timeFormat.format((double)(end - start) / 1000.0) + " seconds and yields " + matched + " matches");
        }
        return matched;
    }

    private static void applyPenaltyOnDemand(IScanMSD unknown, IScanMSD reference, IComparisonResult comparisonResult, IIdentifierSettingsMSD identifierSettings) {
        block11: {
            float penalty = 0.0f;
            String penaltyCalculation = identifierSettings.getPenaltyCalculation();
            if (penaltyCalculation == null) break block11;
            switch (penaltyCalculation) {
                case "RT": {
                    penalty = PenaltyCalculationSupport.calculatePenaltyFromRetentionTime((int)unknown.getRetentionTime(), (int)reference.getRetentionTime(), (int)identifierSettings.getRetentionTimeWindow(), (float)identifierSettings.getPenaltyCalculationLevelFactor(), (float)identifierSettings.getMaxPenalty());
                    break;
                }
                case "RI": {
                    penalty = PenaltyCalculationSupport.calculatePenaltyFromRetentionIndex((IScanMSD)unknown, (IScanMSD)reference, (float)identifierSettings.getRetentionIndexWindow(), (float)identifierSettings.getPenaltyCalculationLevelFactor(), (float)identifierSettings.getMaxPenalty());
                }
            }
            if (penalty != 0.0f) {
                comparisonResult.setPenalty(penalty);
            }
        }
    }

    private static boolean isValidTarget(IComparisonResult comparisonResult, float minMatchFactor, float minReverseMatchFactor) {
        return comparisonResult.getMatchFactor() >= minMatchFactor && comparisonResult.getReverseMatchFactor() >= minReverseMatchFactor;
    }

    private static final class FindMatchingSpectras
    extends RecursiveTask<Map<IComparisonResult, IScanMSD>> {
        private static final long serialVersionUID = 1L;
        private static final int THRESHOLD = 400;
        private final IScanMSD unknown;
        private final List<? extends IScanMSD> references;
        private final IFileIdentifierSettings settings;
        private final IMassSpectrumComparator spectrumComparator;
        private MatchConstraints matchConstraints;

        public FindMatchingSpectras(IScanMSD unknown, List<? extends IScanMSD> references, IFileIdentifierSettings settings, IMassSpectrumComparator spectrumComparator) {
            this.unknown = unknown;
            this.references = references;
            this.settings = settings;
            this.spectrumComparator = spectrumComparator;
            float minMatchFactor = settings.getMinMatchFactor() / 100.0f;
            float minReverseMatchFactor = settings.getMinReverseMatchFactor() / 100.0f;
            this.matchConstraints = new MatchConstraints(minMatchFactor, minReverseMatchFactor);
        }

        @Override
        protected Map<IComparisonResult, IScanMSD> compute() {
            int size = this.references.size();
            if (size > 400) {
                int half = size / 2;
                FindMatchingSpectras forkPart = new FindMatchingSpectras(this.unknown, this.references.subList(0, half), this.settings, this.spectrumComparator);
                forkPart.fork();
                FindMatchingSpectras directPart = new FindMatchingSpectras(this.unknown, this.references.subList(half, size), this.settings, this.spectrumComparator);
                Object map = directPart.compute();
                map.putAll((Map)forkPart.join());
                return map;
            }
            return this.findMatchingReferences();
        }

        private Map<IComparisonResult, IScanMSD> findMatchingReferences() {
            IdentityHashMap<IComparisonResult, IScanMSD> results = new IdentityHashMap<IComparisonResult, IScanMSD>();
            float minMatchFactor = this.settings.getMinMatchFactor();
            float minReverseMatchFactor = this.settings.getMinReverseMatchFactor();
            for (IScanMSD iScanMSD : this.references) {
                IProcessingInfo infoCompare = this.spectrumComparator.compare(this.unknown, iScanMSD, this.matchConstraints);
                IComparisonResult comparisonResult = (IComparisonResult)infoCompare.getProcessingResult();
                FileIdentifier.applyPenaltyOnDemand(this.unknown, iScanMSD, comparisonResult, this.settings);
                if (!FileIdentifier.isValidTarget(comparisonResult, minMatchFactor, minReverseMatchFactor)) continue;
                results.put(comparisonResult, iScanMSD);
            }
            return results;
        }
    }
}

