/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.core.IPeakQuantifierSupplier;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.core.IPeakQuantifierSupport;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.core.PeakQuantifier;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.exceptions.NoPeakQuantifierAvailableException;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.settings.IPeakQuantifierSettings;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.supplier.ChromatogramSelectionProcessorSupplier;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={IProcessTypeSupplier.class})
public class PeakQuantifierProcessTypeSupplier
implements IProcessTypeSupplier {
    public String getCategory() {
        return "Peak Quantifier";
    }

    public Collection<IProcessSupplier<?>> getProcessorSuppliers() {
        try {
            IPeakQuantifierSupport support = PeakQuantifier.getPeakQuantifierSupport();
            ArrayList list = new ArrayList();
            for (String processorId : support.getAvailablePeakQuantifierIds()) {
                IPeakQuantifierSupplier supplier = support.getPeakQuantifierSupplier(processorId);
                list.add((IProcessSupplier<?>)new PeakQuantifierProcessorSupplier(supplier, this));
            }
            return list;
        }
        catch (NoPeakQuantifierAvailableException e) {
            return Collections.emptyList();
        }
    }

    private static final class PeakQuantifierProcessorSupplier
    extends ChromatogramSelectionProcessorSupplier<IPeakQuantifierSettings> {
        public PeakQuantifierProcessorSupplier(IPeakQuantifierSupplier supplier, IProcessTypeSupplier parent) {
            super(supplier.getId(), supplier.getPeakQuantifierName(), supplier.getDescription(), supplier.getSettingsClass(), parent, new DataType[]{DataType.MSD, DataType.CSD});
        }

        public IChromatogramSelection<?, ?> apply(IChromatogramSelection<?, ?> chromatogramSelection, IPeakQuantifierSettings processSettings, MessageConsumer messageConsumer, IProgressMonitor monitor) {
            List peaks = chromatogramSelection.getChromatogram().getPeaks();
            if (processSettings instanceof IPeakQuantifierSettings) {
                messageConsumer.addMessages((MessageProvider)PeakQuantifier.quantify(peaks, processSettings, this.getId(), monitor));
            } else {
                messageConsumer.addMessages((MessageProvider)PeakQuantifier.quantify(peaks, this.getId(), monitor));
            }
            return chromatogramSelection;
        }
    }
}

