/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.peak.detector.core;

import org.eclipse.chemclipse.chromatogram.peak.detector.core.IPeakDetector;
import org.eclipse.chemclipse.chromatogram.peak.detector.settings.IPeakDetectorSettings;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractPeakDetector<P extends IPeak, C extends IChromatogram<P>, R>
implements IPeakDetector<P, C, R> {
    @Override
    public IProcessingInfo<R> validate(IChromatogramSelection<P, C> chromatogramSelection, IPeakDetectorSettings peakDetectorSettings, IProgressMonitor monitor) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        if (chromatogramSelection == null) {
            processingInfo.addErrorMessage("Peak Detector", "The chromatogram selection must not be null.");
        }
        if (peakDetectorSettings == null) {
            processingInfo.addErrorMessage("Peak Detector", "The peak detector settings must not be null.");
        }
        return processingInfo;
    }
}

