/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.core;

import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.core.IBaselineDetector;
import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.settings.IBaselineDetectorSettings;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractBaselineDetector
implements IBaselineDetector {
    private static final String ERROR_DESCRIPTION = "Baseline Detector";

    @Override
    public IProcessingInfo validate(IChromatogramSelection chromatogramSelection, IBaselineDetectorSettings baselineDetectorSettings, IProgressMonitor monitor) {
        ProcessingMessage processingMessage;
        ProcessingInfo processingInfo = new ProcessingInfo();
        if (chromatogramSelection == null) {
            processingMessage = new ProcessingMessage(MessageType.ERROR, ERROR_DESCRIPTION, "The chromatogram selection is invalid.");
            processingInfo.addMessage((IProcessingMessage)processingMessage);
        } else if (chromatogramSelection.getChromatogram() == null) {
            processingMessage = new ProcessingMessage(MessageType.ERROR, ERROR_DESCRIPTION, "The chromatogram is invalid.");
            processingInfo.addMessage((IProcessingMessage)processingMessage);
        }
        if (baselineDetectorSettings == null) {
            processingMessage = new ProcessingMessage(MessageType.ERROR, ERROR_DESCRIPTION, "The baseline detector settings are invalid.");
            processingInfo.addMessage((IProcessingMessage)processingMessage);
        }
        return processingInfo;
    }

    @Override
    public IProcessingInfo validate(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        if (chromatogramSelection == null) {
            ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, ERROR_DESCRIPTION, "The chromatogram selection is invalid.");
            processingInfo.addMessage((IProcessingMessage)processingMessage);
        } else if (chromatogramSelection.getChromatogram() == null) {
            ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, ERROR_DESCRIPTION, "The chromatogram is invalid.");
            processingInfo.addMessage((IProcessingMessage)processingMessage);
        }
        return processingInfo;
    }

    @Override
    public IProcessingInfo validate(IBaselineDetectorSettings baselineDetectorSettings, IProgressMonitor monitor) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        if (baselineDetectorSettings == null) {
            ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, ERROR_DESCRIPTION, "The baseline detector settings are invalid.");
            processingInfo.addMessage((IProcessingMessage)processingMessage);
        }
        return processingInfo;
    }
}

