/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.chart3d;

import javafx.embed.swt.FXCanvas;
import javafx.event.EventHandler;
import javafx.scene.AmbientLight;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.Scene;
import javafx.scene.SceneAntialiasing;
import javafx.scene.SubScene;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.EvaluationPCA;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IResultsPCA;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.chart3d.ScorePlot3DAxes;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.chart3d.ScorePlot3DScatter;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.chart3d.ScorePlot3DSettings;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class ScorePlot3D {
    private ScorePlot3DAxes axes;
    private FXCanvas fxCanvas;
    private final double rotateModifier = 10.0;
    private ScorePlot3DScatter scatter;
    private ScorePlot3DSettings settings;

    public ScorePlot3D(Composite parent, int style) {
        this.fxCanvas = new FXCanvas(parent, style);
        this.fxCanvas.setLayoutData(null);
        this.settings = new ScorePlot3DSettings(800);
        this.axes = new ScorePlot3DAxes(this.settings);
        this.axes.buildAxes();
        this.scatter = new ScorePlot3DScatter(this.settings);
        parent.addListener(11, event -> this.createScene());
        this.createScene();
    }

    public void removeData() {
        this.scatter = new ScorePlot3DScatter(this.settings);
        this.createScene();
        this.createScene();
    }

    public void setInput(EvaluationPCA evaluationPCA) {
        if (evaluationPCA != null) {
            IResultsPCA resultsPCA = evaluationPCA.getResults();
            ScorePlot3DSettings.setSettings(this.settings, resultsPCA);
            ScorePlot3DSettings.setAxesEnhanced(this.settings, 800);
            this.axes = new ScorePlot3DAxes(this.settings);
            this.axes.buildAxes();
            this.scatter = new ScorePlot3DScatter(this.settings, resultsPCA);
            this.createScene();
        }
    }

    public void updateSelection() {
        this.scatter.updateSelection();
        this.fxCanvas.redraw();
    }

    public ScorePlot3DSettings getSettings() {
        return this.settings;
    }

    private void createScene() {
        Group root = new Group();
        AmbientLight ambientlight = new AmbientLight();
        Group mainGroup = new Group();
        PerspectiveCamera camera = new PerspectiveCamera(true);
        camera.setTranslateZ(-4000.0);
        camera.setNearClip(0.01);
        camera.setFarClip(10000.0);
        root.getChildren().addAll((Object[])new Node[]{mainGroup, ambientlight, camera});
        Group objects = new Group();
        objects.getChildren().addAll((Object[])new Node[]{this.scatter.getScarter(), this.axes});
        Rotate rotate = new Rotate(180.0, 0.0, 0.0, 0.0, Rotate.X_AXIS);
        objects.getTransforms().add((Object)rotate);
        mainGroup.getChildren().add((Object)objects);
        BorderPane borderPane = new BorderPane();
        Point sizeScene = this.fxCanvas.getParent().getSize();
        SubScene mainScene = new SubScene((Parent)root, (double)sizeScene.x, (double)sizeScene.y - borderPane.getHeight(), true, SceneAntialiasing.BALANCED);
        mainScene.setFill((Paint)Color.WHITE);
        mainScene.setCamera((Camera)camera);
        this.makeZoomable(mainScene, mainGroup);
        this.mousePressedOrMoved(mainScene, mainGroup);
        BorderPane pane = new BorderPane((Node)mainScene, (Node)borderPane, null, null, null);
        pane.layout();
        Scene scene = new Scene((Parent)pane, (double)sizeScene.x, (double)sizeScene.y);
        this.fxCanvas.setScene(scene);
        pane.setCenter((Node)mainScene);
        this.fxCanvas.getParent().layout(true);
    }

    private void makeZoomable(SubScene scene, final Group group) {
        double MAX_SCALE = 200000.0;
        double MIN_SCALE = 0.1;
        scene.addEventFilter(ScrollEvent.ANY, (EventHandler)new EventHandler<ScrollEvent>(){

            public void handle(ScrollEvent event) {
                double delta = 1.2;
                double scale = group.getScaleX();
                scale = event.getDeltaY() < 0.0 ? (scale /= delta) : (scale *= delta);
                scale = scale < 200000.0 ? scale : 200000.0;
                scale = 0.1 < scale ? scale : 0.1;
                group.setScaleX(scale);
                group.setScaleY(scale);
            }
        });
    }

    private void mousePressedOrMoved(SubScene sceneRoot, Group group) {
        final Rotate xRotate = new Rotate(0.0, 0.0, 0.0, 0.0, Rotate.X_AXIS);
        final Rotate yRotate = new Rotate(0.0, 0.0, 0.0, 0.0, Rotate.Y_AXIS);
        group.getTransforms().addAll((Object[])new Transform[]{xRotate, yRotate});
        sceneRoot.addEventFilter(MouseEvent.ANY, (EventHandler)new EventHandler<MouseEvent>(){
            private double mouseXold = 0.0;
            private double mouseYold = 0.0;

            public void handle(MouseEvent event) {
                if (event.getEventType() == MouseEvent.MOUSE_PRESSED || event.getEventType() == MouseEvent.MOUSE_DRAGGED) {
                    double mouseXnew = event.getSceneX();
                    double mouseYnew = event.getSceneY();
                    if (event.getEventType() == MouseEvent.MOUSE_DRAGGED) {
                        double pitchRotate = xRotate.getAngle() + (mouseYnew - this.mouseYold) / 10.0;
                        xRotate.setAngle(pitchRotate);
                        double a = Math.abs(pitchRotate % 360.0);
                        double yawRotate = a < 90.0 || a > 270.0 ? yRotate.getAngle() - (mouseXnew - this.mouseXold) / 10.0 : yRotate.getAngle() + (mouseXnew - this.mouseXold) / 10.0;
                        yRotate.setAngle(yawRotate);
                    }
                    this.mouseXold = mouseXnew;
                    this.mouseYold = mouseYnew;
                }
            }
        });
    }
}

