/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.IExtractionData;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.ScansExtractionSupport;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IDataInputEntry;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.Samples;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.msd.converter.chromatogram.ChromatogramConverterMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class PcaExtractionScans
implements IExtractionData {
    private List<IDataInputEntry> dataInputEntries;
    private ScansExtractionSupport.ExtractionType extractionType;
    private int maximalNumberScans;
    private int retentionTimeWindow;
    private boolean useDefaultProperties;

    public PcaExtractionScans(int retentionTimeWindow, int maximalNumberScans, List<IDataInputEntry> dataInputEntries, ScansExtractionSupport.ExtractionType scanAlignment, boolean useDefaultProperties) {
        this.retentionTimeWindow = retentionTimeWindow;
        this.dataInputEntries = dataInputEntries;
        this.extractionType = scanAlignment;
        this.useDefaultProperties = useDefaultProperties;
        this.maximalNumberScans = maximalNumberScans;
    }

    @Override
    public Samples process(IProgressMonitor monitor) {
        ScansExtractionSupport scansExtractionSupport = new ScansExtractionSupport(this.retentionTimeWindow, this.maximalNumberScans, this.extractionType, this.useDefaultProperties);
        HashMap<IDataInputEntry, Collection<IScan>> inputData = new HashMap<IDataInputEntry, Collection<IScan>>();
        for (IDataInputEntry input : this.dataInputEntries) {
            IProcessingInfo processingInfo = ChromatogramConverterMSD.getInstance().convert(new File(input.getInputFile()), monitor);
            List scans = ((IChromatogramMSD)processingInfo.getProcessingResult()).getScans();
            inputData.put(input, scans);
        }
        return scansExtractionSupport.process(inputData, monitor);
    }
}

