/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.algorithms;

import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.exception.MathIllegalArgumentException;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.AbstractMultivariateCalculator;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.NormOps_DDRM;

public class CalculatorNIPALS
extends AbstractMultivariateCalculator {
    public CalculatorNIPALS(int numObs, int numVars, int numComps) throws MathIllegalArgumentException {
        super(numObs, numVars, numComps);
    }

    @Override
    public void compute() {
        int numberOfSamples = this.getSampleData().getNumRows();
        int numberOfVariables = this.getSampleData().getNumCols();
        double threshold = 1.0E-5;
        DMatrixRMaj E = this.getSampleData().copy();
        double scoreDotOld = 0.0;
        double scoreDotNew = 0.0;
        DMatrixRMaj p = new DMatrixRMaj(1, numberOfVariables);
        DMatrixRMaj t = CommonOps_DDRM.extract((DMatrixRMaj)E, (int)0, (int)numberOfSamples, (int)0, (int)1);
        DMatrixRMaj pMatrix = new DMatrixRMaj(1, numberOfVariables);
        DMatrixRMaj tMatrix = new DMatrixRMaj(1, numberOfSamples);
        this.setLoadings(new DMatrixRMaj(this.getNumComps(), numberOfVariables));
        this.setScores(new DMatrixRMaj(numberOfSamples, this.getNumComps()));
        int i = 0;
        while (i < this.getNumComps()) {
            int bailOut = 10000;
            do {
                scoreDotOld = scoreDotNew;
                double tMultiplied = 1.0 / CommonOps_DDRM.dot((DMatrixD1)t, (DMatrixD1)t);
                tMatrix.reshape(numberOfSamples, 1);
                t.reshape(numberOfSamples, 1);
                CommonOps_DDRM.extract((DMatrix)t, (int)0, (int)numberOfSamples, (int)0, (int)1, (DMatrix)tMatrix, (int)0, (int)0);
                tMatrix.reshape(1, numberOfSamples);
                CommonOps_DDRM.mult((double)tMultiplied, (DMatrix1Row)tMatrix, (DMatrix1Row)E, (DMatrix1Row)p);
                NormOps_DDRM.normalizeF((DMatrixRMaj)p);
                double pMultiplied = 1.0 / CommonOps_DDRM.dot((DMatrixD1)p, (DMatrixD1)p);
                CommonOps_DDRM.extract((DMatrix)p, (int)0, (int)1, (int)0, (int)numberOfVariables, (DMatrix)pMatrix, (int)0, (int)0);
                pMatrix.reshape(numberOfVariables, 1);
                CommonOps_DDRM.mult((double)pMultiplied, (DMatrix1Row)E, (DMatrix1Row)pMatrix, (DMatrix1Row)t);
                pMatrix.reshape(1, numberOfVariables);
            } while (Math.abs(scoreDotOld - (scoreDotNew = CommonOps_DDRM.dot((DMatrixD1)t, (DMatrixD1)t))) > 1.0E-5 && --bailOut != 0);
            CommonOps_DDRM.extract((DMatrix)t, (int)0, (int)numberOfSamples, (int)0, (int)1, (DMatrix)this.getScores(), (int)0, (int)i);
            CommonOps_DDRM.extract((DMatrix)p, (int)0, (int)1, (int)0, (int)numberOfVariables, (DMatrix)this.getLoadings(), (int)i, (int)0);
            DMatrixRMaj E_sub = new DMatrixRMaj(numberOfSamples, numberOfVariables);
            tMatrix.reshape(numberOfSamples, 1);
            CommonOps_DDRM.mult((DMatrix1Row)tMatrix, (DMatrix1Row)pMatrix, (DMatrix1Row)E_sub);
            CommonOps_DDRM.subtractEquals((DMatrixD1)E, (DMatrixD1)E_sub);
            ++i;
        }
        this.setComputeSuccess();
    }
}

