/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.AbstractDataModificator;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.IReplacer;
import org.eclipse.chemclipse.model.statistics.ISample;
import org.eclipse.chemclipse.model.statistics.ISampleData;
import org.eclipse.chemclipse.model.statistics.ISamples;
import org.eclipse.chemclipse.model.statistics.IVariable;

public class MedianValuesReplacer
extends AbstractDataModificator
implements IReplacer {
    @Override
    public String getDescription() {
        return "Replace NAN value with median";
    }

    @Override
    public String getName() {
        return "Median Value Setter";
    }

    @Override
    public <V extends IVariable, S extends ISample> void process(ISamples<V, S> samples) {
        List variables = samples.getVariables();
        List sampleList = samples.getSampleList();
        int i = 0;
        while (i < variables.size()) {
            if (!this.skipVariable(samples, i)) {
                ArrayList<Double> collectedValues = new ArrayList<Double>();
                for (ISample sample : sampleList) {
                    double sampleData;
                    if (!sample.isSelected() && this.isOnlySelected() || Double.isNaN(sampleData = this.getData((ISampleData)sample.getSampleData().get(i)))) continue;
                    collectedValues.add(sampleData);
                }
                int lenght = collectedValues.size();
                collectedValues.sort((d1, d2) -> Double.compare(d1, d2));
                double median = 0.0;
                if (lenght != 0) {
                    median = lenght % 2 == 0 ? ((Double)collectedValues.get(lenght / 2 - 1) + (Double)collectedValues.get(lenght / 2)) / 2.0 : (Double)collectedValues.get(lenght / 2);
                }
                for (ISample sample : sampleList) {
                    ISampleData sampleData;
                    if (!sample.isSelected() && this.isOnlySelected() || !Double.isNaN(this.getData(sampleData = (ISampleData)sample.getSampleData().get(i)))) continue;
                    sampleData.setModifiedData(median);
                }
            }
            ++i;
        }
    }
}

