/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.comparator;

import java.util.Comparator;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.support.comparator.SortOrder;

public class PeakAreaComparator
implements Comparator<IPeak> {
    private SortOrder sortOrder;

    public PeakAreaComparator() {
        this.sortOrder = SortOrder.ASC;
    }

    public PeakAreaComparator(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    @Override
    public int compare(IPeak peak1, IPeak peak2) {
        int returnValue;
        double integratedArea1 = peak1.getIntegratedArea();
        double integratedArea2 = peak2.getIntegratedArea();
        switch (this.sortOrder) {
            case ASC: {
                returnValue = Double.compare(integratedArea1, integratedArea2);
                break;
            }
            case DESC: {
                returnValue = Double.compare(integratedArea2, integratedArea1);
                break;
            }
            default: {
                returnValue = Double.compare(integratedArea1, integratedArea2);
            }
        }
        return returnValue;
    }
}

