/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.core;

import java.io.Serializable;
import java.util.List;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.PeakException;
import org.eclipse.chemclipse.numeric.equations.LinearEquation;

public interface IPeakModel
extends Serializable {
    public static final int MINIMUM_SCANS = 3;

    public float getBackgroundAbundance(int var1);

    public float getBackgroundAbundance();

    public float getPeakAbundance(int var1);

    public float getPeakAbundance();

    public float getPeakAbundanceByInflectionPoints();

    public int getWidthBaselineTotal();

    public int getWidthBaselineByInflectionPoints();

    public int getWidthByInflectionPoints();

    public int getWidthByInflectionPoints(float var1);

    public int getStartRetentionTime();

    public int getStopRetentionTime();

    public int getRetentionTimeAtPeakMaximum();

    public int getRetentionTimeAtPeakMaximumByInflectionPoints();

    public void replaceRetentionTimes(List<Integer> var1) throws IllegalArgumentException, PeakException;

    public int getNumberOfScans();

    public float getIncreasingInflectionPointAbundance(int var1);

    public float getDecreasingInflectionPointAbundance(int var1);

    public double getGradientAngle();

    public float getLeading();

    public float getTailing();

    public List<Integer> getRetentionTimes();

    public LinearEquation getIncreasingInflectionPointEquation();

    public LinearEquation getDecreasingInflectionPointEquation();

    public LinearEquation getPercentageHeightBaselineEquation(float var1);

    public IScan getPeakMaximum();

    public IScan getPeakScan(int var1);

    public float getIntensity(int var1);

    public Object getTemporarilyInfo(String var1);

    public void setTemporarilyInfo(String var1, Object var2);
}

