/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.identifier;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.eclipse.chemclipse.model.comparator.TargetExtendedComparator;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.targets.ITarget;
import org.eclipse.chemclipse.support.comparator.SortOrder;

public interface IIdentificationTarget
extends ITarget {
    public static final TargetExtendedComparator DEFAULT_COMPARATOR = new TargetExtendedComparator(SortOrder.DESC);

    public static IIdentificationTarget getBestIdentificationTarget(Set<IIdentificationTarget> targets) {
        return IIdentificationTarget.getBestIdentificationTarget(targets, DEFAULT_COMPARATOR);
    }

    public static IIdentificationTarget getBestIdentificationTarget(Set<IIdentificationTarget> targets, Comparator<IIdentificationTarget> comparator) {
        IIdentificationTarget identificationTarget = null;
        if (targets != null && targets.size() > 0) {
            if (targets.size() == 1) {
                identificationTarget = targets.iterator().next();
            } else {
                ArrayList<IIdentificationTarget> targetsList = new ArrayList<IIdentificationTarget>(targets);
                if (comparator != null) {
                    Collections.sort(targetsList, comparator);
                }
                identificationTarget = (IIdentificationTarget)targetsList.get(0);
            }
        }
        return identificationTarget;
    }

    public static ILibraryInformation getBestLibraryInformation(Set<IIdentificationTarget> targets) {
        return IIdentificationTarget.getBestLibraryInformation(targets, DEFAULT_COMPARATOR);
    }

    public static ILibraryInformation getBestLibraryInformation(Set<IIdentificationTarget> targets, Comparator<IIdentificationTarget> comparator) {
        IIdentificationTarget identificationTarget = IIdentificationTarget.getBestIdentificationTarget(targets, comparator);
        return identificationTarget != null ? identificationTarget.getLibraryInformation() : null;
    }

    public ILibraryInformation getLibraryInformation();

    public IComparisonResult getComparisonResult();

    public String getIdentifier();

    public void setIdentifier(String var1);

    public boolean isManuallyVerified();

    public void setManuallyVerified(boolean var1);
}

