/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.methods;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.chemclipse.model.methods.ListProcessEntryContainer;
import org.eclipse.chemclipse.processing.DataCategory;
import org.eclipse.chemclipse.processing.methods.IProcessEntry;
import org.eclipse.chemclipse.processing.methods.ProcessEntryContainer;

public final class ProcessEntry
extends ListProcessEntryContainer
implements IProcessEntry {
    private String processorId;
    private String jsonSettings;
    private final ProcessEntryContainer parent;
    private final EnumSet<DataCategory> categories = EnumSet.noneOf(DataCategory.class);

    public ProcessEntry(ProcessEntryContainer parent) {
        this(null, parent);
    }

    public ProcessEntry(IProcessEntry other, ProcessEntryContainer newParent) {
        super((ProcessEntryContainer)other);
        this.parent = newParent;
        if (other != null) {
            this.processorId = other.getProcessorId();
            this.setName(other.getName());
            this.setDescription(other.getDescription());
            this.jsonSettings = other.getSettings();
            this.categories.addAll(other.getDataCategories());
            this.setReadOnly(other.isReadOnly());
        }
    }

    public String getProcessorId() {
        if (this.processorId == null) {
            return "-not set-";
        }
        return this.processorId;
    }

    public void setProcessorId(String processorId) {
        this.processorId = processorId;
    }

    public String getSettings() {
        if (this.jsonSettings == null) {
            return "";
        }
        return this.jsonSettings;
    }

    public void setSettings(String jsonSettings) {
        this.jsonSettings = jsonSettings;
    }

    public ProcessEntryContainer getParent() {
        return this.parent;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ProcessEntry [processorId=");
        builder.append(this.processorId);
        builder.append(", name=");
        builder.append(this.getName());
        builder.append(", description=");
        builder.append(this.getDescription());
        builder.append(", jsonSettings=");
        builder.append(this.jsonSettings);
        builder.append(", parent=");
        builder.append(this.parent);
        builder.append("]");
        return builder.toString();
    }

    public Set<DataCategory> getDataCategories() {
        return Collections.unmodifiableSet(this.categories);
    }

    public void addDataCategory(DataCategory category) {
        this.categories.add(category);
    }

    public void removeDataCategory(DataCategory category) {
        this.categories.remove(category);
    }
}

