/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.quantitation;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.chemclipse.model.quantitation.IQuantitationSignal;
import org.eclipse.chemclipse.model.quantitation.IQuantitationSignals;

public class QuantitationSignals
extends TreeSet<IQuantitationSignal>
implements IQuantitationSignals {
    private static final long serialVersionUID = 6123008658126987673L;

    @Override
    public List<Double> getSelectedSignals() {
        ArrayList<Double> signals = new ArrayList<Double>();
        for (IQuantitationSignal quantitationSignal : this) {
            if (!quantitationSignal.isUse()) continue;
            signals.add(quantitationSignal.getSignal());
        }
        return signals;
    }

    @Override
    public void deselectAllSignals() {
        this.setSignalsUse(false);
    }

    @Override
    public void selectAllSignals() {
        this.setSignalsUse(true);
    }

    @Override
    public void selectSignal(double signal) {
        for (IQuantitationSignal quantitationSignal : this) {
            if (quantitationSignal.getSignal() != signal) continue;
            quantitationSignal.setUse(true);
        }
    }

    private void setSignalsUse(boolean use) {
        for (IQuantitationSignal quantitationSignal : this) {
            quantitationSignal.setUse(use);
        }
    }
}

