/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.ranges;

public class TimeRange {
    public static final float MINUTE_FACTOR = 60000.0f;
    private String identifier = "";
    private int start = 0;
    private int center = 0;
    private int stop = 0;

    public TimeRange(String identifier, int start, int stop) throws IllegalArgumentException {
        this(identifier, start, TimeRange.calculateCenter(start, stop), stop);
    }

    public TimeRange(String identifier, int start, int center, int stop) throws IllegalArgumentException {
        if (start < 0 || center < 0 || stop < 0) {
            throw new IllegalArgumentException("Start/Center/Stop must be >= 0.");
        }
        this.identifier = identifier != null ? identifier : "";
        this.start = Math.min(start, stop);
        this.stop = Math.max(start, stop);
        this.updateCenter();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getStart() {
        return this.start;
    }

    public int getCenter() {
        return this.center;
    }

    public int getStop() {
        return this.stop;
    }

    public void update(int start, int stop) {
        this.start = Math.min(start, stop);
        this.stop = Math.max(start, stop);
        this.updateCenter();
    }

    public void update(int start, int center, int stop) {
        this.update(start, stop);
        this.updateCenter(center);
    }

    public void updateStart(int start) {
        if (start <= this.stop) {
            this.start = start;
            if (start >= this.center) {
                this.updateCenter();
            }
        }
    }

    public void updateCenter() {
        this.center = TimeRange.calculateCenter(this.start, this.stop);
    }

    public void updateCenter(int center) {
        if (center >= this.start && center <= this.stop) {
            this.center = center;
        }
    }

    public void updateStop(int stop) {
        if (stop >= this.start) {
            this.stop = stop;
            if (stop <= this.center) {
                this.updateCenter();
            }
        }
    }

    private static int calculateCenter(int start, int stop) {
        int min = Math.min(start, stop);
        int max = Math.max(start, stop);
        int center = 0;
        int delta = max - min;
        center = delta != 0 ? delta / 2 + min : min;
        return center;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeRange other = (TimeRange)obj;
        return !(this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier));
    }

    public String toString() {
        return "TimeRange [identifier=" + this.identifier + ", start=" + this.start + ", center=" + this.center + ", stop=" + this.stop + "]";
    }

    public static enum Marker {
        START,
        CENTER,
        STOP;

    }
}

