/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.pdfbox.extensions.elements;

import java.awt.Color;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.eclipse.chemclipse.pdfbox.extensions.elements.TextElement;
import org.eclipse.chemclipse.pdfbox.extensions.settings.ReferenceX;
import org.eclipse.chemclipse.pdfbox.extensions.settings.ReferenceY;
import org.eclipse.chemclipse.pdfbox.extensions.settings.TextOption;

public class CellElement
extends TextElement {
    public static int BORDER_NONE = 0;
    public static int BORDER_LEFT = 1;
    public static int BORDER_RIGHT = 2;
    public static int BORDER_TOP = 4;
    public static int BORDER_BOTTOM = 8;
    public static int BORDER_ALL = BORDER_LEFT | BORDER_RIGHT | BORDER_TOP | BORDER_BOTTOM;
    private int border = BORDER_NONE;

    public CellElement(String text, float maxWidth) {
        this(text, maxWidth, BORDER_NONE);
    }

    public CellElement(String text, float maxWidth, int border) {
        super(-1.0f, -1.0f, maxWidth);
        this.setText(text);
        this.border = border;
    }

    public boolean isBorderSet() {
        return this.border > BORDER_NONE;
    }

    public boolean isBorderSet(int constant) {
        return (this.border & constant) == constant;
    }

    public CellElement setBorder(int border) {
        this.border = border;
        return this;
    }

    @Override
    public CellElement setFont(PDFont font) {
        super.setFont(font);
        return this;
    }

    @Override
    public CellElement setFontSize(float fontSize) {
        super.setFontSize(fontSize);
        return this;
    }

    @Override
    public CellElement setColor(Color color) {
        super.setColor(color);
        return this;
    }

    @Override
    public CellElement setMinHeight(float minHeight) {
        super.setMinHeight(minHeight);
        return this;
    }

    @Override
    public CellElement setMaxWidth(float maxWidth) {
        super.setMaxWidth(maxWidth);
        return this;
    }

    @Override
    public CellElement setText(String text) {
        super.setText(text);
        return this;
    }

    @Override
    public CellElement setTextOption(TextOption textOption) {
        super.setTextOption(textOption);
        return this;
    }

    @Override
    public CellElement setReferenceX(ReferenceX referenceX) {
        super.setReferenceX(referenceX);
        return this;
    }

    @Override
    public CellElement setReferenceY(ReferenceY referenceY) {
        super.setReferenceY(referenceY);
        return this;
    }

    @Override
    public CellElement setX(float x) {
        super.setX(x);
        return this;
    }

    @Override
    public CellElement setY(float y) {
        super.setY(y);
        return this;
    }
}

