/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.processing.ui.internal.provider;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.processing.converter.SupplierContext;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;

public class EclipseSupplierFileIdentifier
implements SupplierContext {
    private Collection<ISupplier> list;

    public Collection<ISupplier> getSupplier() {
        if (this.list == null) {
            IFileEditorMapping[] editorMappings;
            ArrayList<EclipseEditorSupplier> items = new ArrayList<EclipseEditorSupplier>();
            IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
            IFileEditorMapping[] iFileEditorMappingArray = editorMappings = editorRegistry.getFileEditorMappings();
            int n = editorMappings.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorDescriptor[] editors;
                IFileEditorMapping editorMapping = iFileEditorMappingArray[n2];
                IEditorDescriptor[] iEditorDescriptorArray = editors = editorMapping.getEditors();
                int n3 = editors.length;
                int n4 = 0;
                while (n4 < n3) {
                    IEditorDescriptor editorDescriptor = iEditorDescriptorArray[n4];
                    if (!editorDescriptor.isOpenExternal()) {
                        items.add(new EclipseEditorSupplier(editorMapping, editorDescriptor));
                    }
                    ++n4;
                }
                ++n2;
            }
            this.list = Collections.unmodifiableCollection(items);
        }
        return this.list;
    }

    private static class EclipseEditorSupplier
    implements ISupplier {
        private final IFileEditorMapping editorMapping;
        private final IEditorDescriptor editorDescriptor;

        public EclipseEditorSupplier(IFileEditorMapping editorMapping, IEditorDescriptor editorDescriptor) {
            this.editorMapping = editorMapping;
            this.editorDescriptor = editorDescriptor;
        }

        public String getId() {
            return this.editorDescriptor.getId();
        }

        public String getDescription() {
            return this.editorDescriptor.getLabel();
        }

        public String getFilterName() {
            return this.editorDescriptor.getLabel();
        }

        public String getFileExtension() {
            return this.editorMapping.getExtension();
        }

        public String getFileName() {
            return this.editorMapping.getName();
        }

        public String getDirectoryExtension() {
            return "";
        }

        public boolean isExportable() {
            return false;
        }

        public boolean isImportable() {
            return true;
        }

        public boolean isMatchMagicNumber(File file) {
            try {
                IEditorDescriptor descriptor = IDE.getEditorDescriptor((String)file.getName(), (boolean)false, (boolean)false);
                boolean matches = descriptor != null && this.getId().equals(descriptor.getId());
                return matches;
            }
            catch (OperationCanceledException | PartInitException e) {
                return false;
            }
        }

        public String toString() {
            return this.getFilterName();
        }

        @Execute
        public boolean open(File file) {
            IWorkbenchPage page;
            IFileStore fileStore = EFS.getLocalFileSystem().fromLocalFile(file);
            if (fileStore != null && (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
                try {
                    page.openEditor((IEditorInput)new FileStoreEditorInput(fileStore), this.getId());
                    return true;
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
    }
}

