/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.processing.ui.parts;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.ui.support.DynamicProcessingInfoUpdateNotifier;
import org.eclipse.chemclipse.processing.ui.swt.ProcessingInfoUI;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class ProcessingInfoPart {
    public static String ID = "org.eclipse.chemclipse.processing.ui.parts.ProcessingInfoPart";
    private static final String POPUP_MENU_ID = "#PopUpMenu";
    private static final String POPUP_MENU_POSTFIX = "PopUpMenu";
    @Inject
    private Composite parent;
    @Inject
    private DynamicProcessingInfoUpdateNotifier updateNotifier;
    private ProcessingInfoUI processingInfoUI;

    @PostConstruct
    private void createControl() {
        this.parent.setLayout((Layout)new FillLayout());
        this.processingInfoUI = new ProcessingInfoUI(this.parent, 0);
        TableViewer tableViewer = this.processingInfoUI.getTableViewer();
        tableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 99 && e.stateMask == 262144) {
                    ProcessingInfoPart.this.processingInfoUI.copyToClipboard();
                }
            }
        });
        this.initContextMenu();
        this.processingInfoUI.update(this.updateNotifier.getProcessingInfo());
    }

    @Focus
    public void setFocus() {
        this.processingInfoUI.setFocus();
    }

    private void initContextMenu() {
        MenuManager menuManager = new MenuManager(POPUP_MENU_ID, String.valueOf(this.getClass().getName()) + POPUP_MENU_POSTFIX);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action action = new Action(){

                    public void run() {
                        super.run();
                        ProcessingInfoPart.this.processingInfoUI.copyToClipboard();
                    }
                };
                action.setText("Copy selection to clipboard");
                manager.add((IAction)action);
            }
        });
        TableViewer tableViewer = this.processingInfoUI.getTableViewer();
        Menu menu = menuManager.createContextMenu((Control)tableViewer.getTable());
        tableViewer.getTable().setMenu(menu);
    }

    @Inject
    public void update(@Optional @UIEventTopic(value="processinginfo/update") MessageProvider data) {
        if (this.processingInfoUI != null) {
            this.processingInfoUI.update(data);
        }
    }
}

