/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.processing.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiPredicate;
import org.eclipse.chemclipse.processing.Processor;
import org.eclipse.chemclipse.processing.ProcessorFactory;
import org.eclipse.chemclipse.processing.detector.Detector;
import org.eclipse.chemclipse.processing.filter.Filter;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, service={ProcessorFactory.class})
public class OSGiFilterFactory
implements ProcessorFactory {
    private List<ProcessorDescriptor> processorDescriptors = new CopyOnWriteArrayList<ProcessorDescriptor>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addFilter(Filter<?> filter, Map<String, ?> properties) {
        this.addProcessor(filter, properties);
    }

    protected void removeFilter(Filter<?> filter) {
        this.removeProcessor(filter);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addDetector(Detector<?> filter, Map<String, ?> properties) {
        this.addProcessor(filter, properties);
    }

    protected void removeDetector(Detector<?> filter) {
        this.removeProcessor(filter);
    }

    private synchronized void addProcessor(Processor<?> filter, Map<String, ?> properties) {
        this.removeProcessor(filter);
        this.processorDescriptors.add(new ProcessorDescriptor(filter, properties));
    }

    private synchronized void removeProcessor(Processor<?> filter) {
        for (ProcessorDescriptor filterDescriptor : this.processorDescriptors) {
            if (filterDescriptor.processor != filter) continue;
            this.processorDescriptors.remove(filterDescriptor);
            return;
        }
    }

    private synchronized <E> Map<E, Map<String, ?>> getItems(Class<E> classType) {
        IdentityHashMap<E, Map> map = new IdentityHashMap<E, Map>();
        for (ProcessorDescriptor descriptor : this.processorDescriptors) {
            if (!classType.isInstance(descriptor.processor)) continue;
            map.put(classType.cast(descriptor.processor), descriptor.properties);
        }
        return map;
    }

    @Override
    public <T extends Processor<?>> Collection<T> getProcessors(Class<T> processorType, BiPredicate<? super T, Map<String, ?>> acceptor) {
        Map<T, Map<String, ?>> items = this.getItems(processorType);
        if (acceptor != null) {
            Set<Map.Entry<T, Map<String, ?>>> entrySet = items.entrySet();
            Iterator<Map.Entry<T, Map<String, ?>>> iterator = entrySet.iterator();
            while (iterator.hasNext()) {
                Map.Entry<T, Map<String, ?>> entry = iterator.next();
                if (acceptor.test(entry.getKey(), entry.getValue())) continue;
                iterator.remove();
            }
        }
        return items.keySet();
    }

    private static final class ProcessorDescriptor {
        private final Processor<?> processor;
        private final Map<String, ?> properties;

        ProcessorDescriptor(Processor<?> filter, Map<String, ?> properties) {
            this.processor = filter;
            this.properties = new HashMap(properties);
        }

        public String toString() {
            return "Processor: " + this.processor + ", Properties: " + this.properties;
        }
    }
}

