/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.rcp.app.ui.switcher;

import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class PerspectiveSwitcher {
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;
    @Inject
    private EPartService partService;
    @Inject
    private IEventBroker eventBroker;

    public void changePerspective(String perspectiveId) {
        List pespectives = this.modelService.findElements((MUIElement)this.application, null, MPerspective.class, null);
        for (MPerspective mPerspective : pespectives) {
            String elementId = mPerspective.getElementId();
            String elementLabel = mPerspective.getLabel();
            if (!elementId.equals(perspectiveId) && !elementId.equals(String.valueOf(perspectiveId) + "." + elementLabel)) continue;
            this.partService.switchPerspective(mPerspective);
            if (this.eventBroker != null) {
                this.eventBroker.send("application/select/perspective", (Object)elementLabel);
            }
            return;
        }
    }

    public void focusView(String viewId) {
        MUIElement element = this.modelService.find(viewId, (MUIElement)this.application);
        if (element instanceof MPart) {
            MPart part = (MPart)element;
            if (!this.partService.getParts().contains(part)) {
                this.partService.createPart(part.getElementId());
            }
            this.partService.showPart(part, EPartService.PartState.ACTIVATE);
            if (this.eventBroker != null) {
                this.eventBroker.send("application/select/view", (Object)part.getLabel());
            }
        }
    }
}

