/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.preferences;

import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.core.support.MarkedIon;
import org.eclipse.chemclipse.msd.model.core.support.MarkedIons;
import org.eclipse.chemclipse.ux.extension.msd.ui.Activator;
import org.eclipse.jface.preference.IPreferenceStore;

public class PreferenceSupplier {
    public static final String P_SELECTED_ORGANIC_COMPOUND = "selectedOrganicCompound";
    public static final String P_ORGANIC_COMPOUND_HYDROCARBONS = "organicCompoundHydrocarbons";
    public static final String P_ORGANIC_COMPOUND_FATTY_ACIDS = "organicCompoundFattyAcids";
    public static final String P_ORGANIC_COMPOUND_FAME = "organicCompoundFattyAcidsAsMethylEsters";
    public static final String P_MAGNIFICATION_FACTOR = "magnificationFactor";
    public static final int DEF_MAGNIFICATION_FACTOR = 1;
    public static final int DEF_MAGNIFICATION_FACTOR_MIN = 1;
    public static final int DEF_MAGNIFICATION_FACTOR_MAX = 50;
    private static IMarkedIons compoundIonsEmpty = new MarkedIons(IMarkedIons.IonMarkMode.INCLUDE);
    private static int magnificationFactor = -1;
    private static IMarkedIons compoundIonsHydrocarbons = null;
    private static IMarkedIons compoundIonsFattyAcids = null;
    private static IMarkedIons compoundIonsFame = null;
    public static final String P_USE_PROFILE_MASS_SPECTRUM_VIEW = "useProfileMassSpectrumView";
    public static final boolean DEF_USE_PROFILE_MASS_SPECTRUM_VIEW = false;
    public static final String P_PATH_OPEN_CHROMATOGRAMS = "pathOpenChromatograms";
    public static final String DEF_PATH_OPEN_CHROMATOGRAMS = "";

    private PreferenceSupplier() {
    }

    public static String[][] getOrganicCompoundPresets() {
        String[][] organicCompoundPresets = new String[3][2];
        organicCompoundPresets[0] = new String[]{"Hydrocarbons", P_ORGANIC_COMPOUND_HYDROCARBONS};
        organicCompoundPresets[1] = new String[]{"Fatty Acids", P_ORGANIC_COMPOUND_FATTY_ACIDS};
        organicCompoundPresets[2] = new String[]{"FAME", P_ORGANIC_COMPOUND_FAME};
        return organicCompoundPresets;
    }

    public static IMarkedIons getOrganicCompoundIons() {
        IMarkedIons compoundIons;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String selectedOrganicCompound = store.getString(P_SELECTED_ORGANIC_COMPOUND);
        if (magnificationFactor != store.getInt(P_MAGNIFICATION_FACTOR)) {
            compoundIonsHydrocarbons = null;
            compoundIonsFattyAcids = null;
            compoundIonsFame = null;
            magnificationFactor = store.getInt(P_MAGNIFICATION_FACTOR);
        }
        if (selectedOrganicCompound.equals(P_ORGANIC_COMPOUND_HYDROCARBONS)) {
            if (compoundIonsHydrocarbons == null) {
                compoundIonsHydrocarbons = new MarkedIons(IMarkedIons.IonMarkMode.INCLUDE);
                compoundIonsHydrocarbons.add((Object)new MarkedIon(57.0, magnificationFactor));
                compoundIonsHydrocarbons.add((Object)new MarkedIon(71.0, magnificationFactor));
                compoundIonsHydrocarbons.add((Object)new MarkedIon(85.0, magnificationFactor));
            }
            compoundIons = compoundIonsHydrocarbons;
        } else if (selectedOrganicCompound.equals(P_ORGANIC_COMPOUND_FATTY_ACIDS)) {
            if (compoundIonsFattyAcids == null) {
                compoundIonsFattyAcids = new MarkedIons(IMarkedIons.IonMarkMode.INCLUDE);
                compoundIonsFattyAcids.add((Object)new MarkedIon(74.0, magnificationFactor));
                compoundIonsFattyAcids.add((Object)new MarkedIon(87.0, magnificationFactor));
            }
            compoundIons = compoundIonsFattyAcids;
        } else if (selectedOrganicCompound.equals(P_ORGANIC_COMPOUND_FAME)) {
            if (compoundIonsFame == null) {
                compoundIonsFame = new MarkedIons(IMarkedIons.IonMarkMode.INCLUDE);
                compoundIonsFame.add((Object)new MarkedIon(79.0, magnificationFactor));
                compoundIonsFame.add((Object)new MarkedIon(81.0, magnificationFactor));
            }
            compoundIons = compoundIonsFame;
        } else {
            compoundIons = compoundIonsEmpty;
        }
        return compoundIons;
    }

    public static int getOverlayXOffset() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getInt("overlayXOffset");
    }

    public static int getOverlayYOffset() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getInt("overlayYOffset");
    }

    public static boolean useProfileMassSpectrumView() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getBoolean(P_USE_PROFILE_MASS_SPECTRUM_VIEW);
    }

    public static String getPathOpenChromatograms() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getString(P_PATH_OPEN_CHROMATOGRAMS);
    }

    public static void setPathOpenChromatograms(String value) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        store.setValue(P_PATH_OPEN_CHROMATOGRAMS, value);
    }
}

