/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.swt;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.ux.extension.msd.ui.internal.provider.UpdateMenuEntry;
import org.eclipse.chemclipse.ux.extension.msd.ui.swt.IMassSpectrumChart;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.extensions.axisconverter.PercentageConverter;
import org.eclipse.swtchart.extensions.core.IAxisScaleConverter;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.IPrimaryAxisSettings;
import org.eclipse.swtchart.extensions.core.ISeriesData;
import org.eclipse.swtchart.extensions.core.RangeRestriction;
import org.eclipse.swtchart.extensions.core.SecondaryAxisSettings;
import org.eclipse.swtchart.extensions.core.SeriesData;
import org.eclipse.swtchart.extensions.linecharts.LineChart;
import org.eclipse.swtchart.extensions.linecharts.LineSeriesData;
import org.eclipse.swtchart.extensions.menu.IChartMenuEntry;

public class MassSpectrumChartProfile
extends LineChart
implements IMassSpectrumChart {
    private static final int MAX_NUMBER_MZ = 25000;
    private IScanMSD massSpectrum = null;

    public MassSpectrumChartProfile() {
        this.initialize();
    }

    public MassSpectrumChartProfile(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    @Override
    public void update(IScanMSD massSpectrum) {
        this.massSpectrum = massSpectrum;
        this.update();
    }

    @Override
    public void update() {
        this.deleteSeries();
        if (this.massSpectrum != null) {
            ArrayList<LineSeriesData> barSeriesDataList = new ArrayList<LineSeriesData>();
            ISeriesData seriesData = this.getMassSpectrum(this.massSpectrum);
            LineSeriesData lineSeriesData = new LineSeriesData(seriesData);
            barSeriesDataList.add(lineSeriesData);
            this.addSeriesData(barSeriesDataList, 25000);
        }
    }

    private void initialize() {
        IChartSettings chartSettings = this.getChartSettings();
        chartSettings.setOrientation(256);
        chartSettings.setHorizontalSliderVisible(true);
        chartSettings.setVerticalSliderVisible(true);
        chartSettings.setCreateMenu(true);
        chartSettings.addMenuEntry((IChartMenuEntry)new UpdateMenuEntry());
        RangeRestriction rangeRestriction = chartSettings.getRangeRestriction();
        rangeRestriction.setZeroX(false);
        rangeRestriction.setZeroY(false);
        rangeRestriction.setRestrictZoom(true);
        rangeRestriction.setExtendTypeX(RangeRestriction.ExtendType.ABSOLUTE);
        rangeRestriction.setExtendMinX(2.0);
        rangeRestriction.setExtendMaxX(2.0);
        rangeRestriction.setExtendTypeY(RangeRestriction.ExtendType.RELATIVE);
        rangeRestriction.setExtendMaxY(0.1);
        this.setPrimaryAxisSet(chartSettings);
        this.addSecondaryAxisSet(chartSettings);
        this.applySettings(chartSettings);
    }

    private void setPrimaryAxisSet(IChartSettings chartSettings) {
        IPrimaryAxisSettings primaryAxisSettingsX = chartSettings.getPrimaryAxisSettingsX();
        primaryAxisSettingsX.setTitle("m/z");
        primaryAxisSettingsX.setDecimalFormat(new DecimalFormat("0.0##", new DecimalFormatSymbols(Locale.ENGLISH)));
        primaryAxisSettingsX.setColor(this.getDisplay().getSystemColor(2));
        IPrimaryAxisSettings primaryAxisSettingsY = chartSettings.getPrimaryAxisSettingsY();
        primaryAxisSettingsY.setTitle("Intensity");
        primaryAxisSettingsY.setDecimalFormat(new DecimalFormat("0.0#E0", new DecimalFormatSymbols(Locale.ENGLISH)));
        primaryAxisSettingsY.setColor(this.getDisplay().getSystemColor(2));
    }

    private void addSecondaryAxisSet(IChartSettings chartSettings) {
        SecondaryAxisSettings secondaryAxisSettingsY = new SecondaryAxisSettings("Relative Intensity [%]", (IAxisScaleConverter)new PercentageConverter(512, true));
        secondaryAxisSettingsY.setPosition(IAxis.Position.Secondary);
        secondaryAxisSettingsY.setDecimalFormat(new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.ENGLISH)));
        secondaryAxisSettingsY.setColor(this.getDisplay().getSystemColor(2));
        chartSettings.getSecondaryAxisSettingsListY().add(secondaryAxisSettingsY);
    }

    private ISeriesData getMassSpectrum(IScanMSD massSpectrum) {
        List ions = massSpectrum.getIons();
        int size = ions.size();
        double[] xSeries = new double[size];
        double[] ySeries = new double[size];
        int i = 0;
        while (i < size) {
            IIon ion = (IIon)ions.get(i);
            xSeries[i] = ion.getIon();
            ySeries[i] = ion.getAbundance();
            ++i;
        }
        return new SeriesData(xSeries, ySeries, "Mass Spectrum");
    }
}

